% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_binary.R
\name{utility_bias_binary}
\alias{utility_bias_binary}
\alias{utility_binary_L}
\alias{utility_binary_L2}
\alias{utility_binary_R}
\alias{utility_binary_R2}
\title{Utility function for bias adjustment programs with binary distributed outcomes.}
\usage{
utility_binary_L(
  n2,
  RRgo,
  Adj,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_binary_L2(
  n2,
  RRgo,
  Adj,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_binary_R(
  n2,
  RRgo,
  Adj,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_binary_R2(
  n2,
  RRgo,
  Adj,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{RRgo}{threshold value for the go/no-go decision rule}

\item{Adj}{adjustment parameter}

\item{w}{weight for mixture prior distribution}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for \code{p11} in terms of sample size}

\item{in2}{amount of information for \code{p12} in terms of sample size}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"} in RR scale, default: 1}

\item{stepm1}{lower boundary for effect size category \code{"medium"} in RR scale = upper boundary for effect size category "small" in RR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category \code{"large"} in RR scale = upper boundary for effect size category "medium" in RR scale, default: 0.85}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{p11} is used as fixed effect}
}
\value{
The output of the functions \code{utility_binary_L()}, \code{utility_binary_L2()}, \code{utility_binary_R()} and \code{utility_binary_R2()} is the expected utility of the program.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_bias_binary()} function.
}
\examples{
res <- utility_binary_L(n2 = 50, RRgo = 0.8, Adj = 0.1, w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, 
                                 alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 steps1 = 1, stepm1 = 0.95, stepl1 = 0.85,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 fixed = TRUE)
         res <- utility_binary_L2(n2 = 50, RRgo = 0.8, Adj = 0.1, w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, 
                                 alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 steps1 = 1, stepm1 = 0.95, stepl1 = 0.85,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 fixed = TRUE)
         res <- utility_binary_R(n2 = 50, RRgo = 0.8, Adj = 0.9, w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, 
                                 alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 steps1 = 1, stepm1 = 0.95, stepl1 = 0.85,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 fixed = TRUE)
         res <- utility_binary_R2(n2 = 50, RRgo = 0.8, Adj = 0.9, w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, 
                                 alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 steps1 = 1, stepm1 = 0.95, stepl1 = 0.85,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 fixed = TRUE)
}
\keyword{internal}
