% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackBoxDS.R
\name{blackBoxDS}
\alias{blackBoxDS}
\title{Secure ranking of "V2BR" (vector to be ranked) across all sources}
\usage{
blackBoxDS(input.var.name = NULL, shared.seedval, synth.real.ratio, NA.manage)
}
\arguments{
\item{input.var.name}{a character string specifying the name of V2BR. This
argument is set by the argument with the same name in the clientside function
ds.ranksSecure}

\item{shared.seedval}{a pseudorandom number seed that ensures that the
processes generating the order and parameterisation of the encryption
algorithms are the same in each study. This argument is set by the argument
<shared.seed.value> in the clientside function ds.ranksSecure. For more
details, including future plans to share this starting seed in a more secure
way, please see the associated document entitled "secure.global.ranking.docx"
and the header file for ds.ranksSecure.}

\item{synth.real.ratio}{an integer value representing
the ratio of synthetic (pseudo-data) values to the real number of 
values in V2BR. This argument is set by the argument with the same name
in the clientside function ds.ranksSecure. For more details, please see the
associated document entitled "secure.global.ranking.docx" and the header file
for ds.ranksSecure.}

\item{NA.manage}{character string indicating how missing values (NAs) in
V2BR should be managed. It takes three possible values: "NA.delete",
"NA.low","NA.hi". This argument is set by the argument with the same name
in the clientside function ds.ranksSecure. For more details, please see the
associated document entitled "secure.global.ranking.docx" and the header file
for ds.ranksSecure.}
}
\value{
writes a data frame object entitled blackbox.output.df to the
serverside. In each study this contains the encrypted
"combined real+pseudo data vector" and a range of other key components
from the first stage of the ranking procedure. For more details see the
associated document entitled "secure.global.ranking.docx"
}
\description{
The first key serverside function that sets up the V2BR for
ranking in the client.
}
\details{
Severside assign function called by ds.ranksSecure. 
Creates pseudo-data by using the real distribution of values in V2BR
to create a large number of synthetic data with a similar distribution to
the values in V2BR but with a slightly broader distribution at both ends
to ensure that any extreme values in the "combined real+pseudo data vector"
are all pseudo-data. Also ensures that the number of decimal places of
the values in the V2BR is reflected by the number of decimal places in
the pseudodata. Finally, takes the "combined real+pseudo data vector" through
seven rounds of rank consistent encryption that involves algorithms
themselves generated by a pseudorandom process that selects which
transformation to apply and with what parameters. The encryption algorithms
are the same in each study ensuring that ranks also remain consistent between
studies. After encryption the encrypted "combined real+pseudo data vector" is
written to the serverside as a dataframe also including other key component
vectors from the first stage of the ranking procedure.
For more details about the cluster of functions that
collectively enable secure global ranking and estimation of global quantiles
see the associated document entitled "secure.global.ranking.docx". Also
see the header file for ds.ranksSecure
}
\author{
Paul Burton 9th November, 2021
}
