% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmSLMADS2.R
\name{glmSLMADS2}
\alias{glmSLMADS2}
\title{Fit a Generalized Linear Model (GLM) with pooling via Study Level Meta-Analysis (SLMA)}
\usage{
glmSLMADS2(formula, family, offset, weights, newobj, dataName)
}
\arguments{
\item{formula}{a glm formula, specified in call to ds.glmSLMA}

\item{family}{a glm family, specified in call to ds.glmSLMA}

\item{offset}{a character string specifying a variable to be used as an offset.
Specified in call to ds.glmSLMA.}

\item{weights}{a character string specifying a variable to be used as regression weights.
Specified in call to ds.glmSLMA. Specified in call to ds.glmSLMA.}

\item{newobj}{a character string specifying the name of the glm object
written to the serverside by glmSLMADS.assign. This is either the name
specified by the newobj argument in ds.glmSLMA or if newobj was unspecified
or NULL it is called new.glm.obj.}

\item{dataName}{a character string specifying the name of a data.frame
holding the data for the model. Specified in call to ds.glmSLMA.}
}
\value{
All quantitative, Boolean, and character objects required to
enable the SLMA pooling of the separate glm models fitted to each study -
in particular including the study-specific regression coefficients and their corresponding
standard errors.
}
\description{
Fits a generalized linear model (GLM) on data from single or multiple sources
with pooled co-analysis across studies being based on SLMA (Study Level Meta Analysis).
}
\details{
glmSLMADS.assign is an aggregate function called by clientside function ds.glmSLMA.
ds.glmSLMA also calls another aggregate function glmSLMADS2
and an assign function glmSLMADS.assign
For more detailed information see help for ds.glmSLMA.
}
\author{
Paul Burton for DataSHIELD Development Team (14/7/20)
}
