% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmerSLMADS.assign.R
\name{glmerSLMADS.assign}
\alias{glmerSLMADS.assign}
\title{Fitting generalized linear mixed effect models - serverside function}
\usage{
glmerSLMADS.assign(
  formula,
  offset,
  weights,
  dataName,
  family,
  control_type = NULL,
  control_value.transmit = NULL,
  nAGQ = 1L,
  verbose = 0,
  theta = NULL,
  fixef = NULL
)
}
\arguments{
\item{formula}{see help for ds.glmerSLMA}

\item{offset}{see help for ds.glmerSLMA}

\item{weights}{see help for ds.glmerSLMA}

\item{dataName}{see help for ds.glmerSLMA}

\item{family}{see help for ds.glmerSLMA}

\item{control_type}{see help for ds.glmerSLMA}

\item{control_value.transmit}{see help for argument <control_value> for
function ds.glmerSLMA}

\item{nAGQ}{integer scalar, defaulting to 1L. IN PRACTICE, IT MAY BE NECESSARY
TO SET nAGQ TO 0L when the model appears to converge perfectly well (e.g. verbose=2
demonstrates good initial convergence of both the log-likelihood and
regression coefficients) but formal convergence does not get declared - 
so no output is produced - despite running the model for many iterations.
The nAGQ argument is set by the nAGQ argument for ds.glmerSLMA and further
details can be found in help(ds.glmerSLMA) and in the native R help for glmer()}

\item{verbose}{see help for ds.glmerSLMA}

\item{theta}{see help for argument <start_theta> for
function ds.glmerSLMA}

\item{fixef}{see help for argument <start_fixef> for
function ds.glmerSLMA}
}
\value{
writes glmerMod object summarising the fitted model to the serverside.
For more detailed information see help for ds.glmerSLMA.
}
\description{
glmerSLMADS.assign is the same as glmerSLMADS2 which fits a generalized linear
mixed effects model (glme) per study and saves the outcomes in each study
}
\details{
glmerSLMADS.assign is a serverside function called by ds.glmerSLMA on the clientside.
The analytic work engine is the glmer function in R which sits in the lme4 package.
glmerSLMADS.assign fits a generalized linear mixed effects model (glme) - e.g. a logistic or
Poisson regression model including both fixed and random effects - on data
from each single data source and saves the regression outcomes on the serveside.
}
\author{
Demetris Avraam for DataSHIELD Development Team
}
