% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2DDS.R
\name{table2DDS}
\alias{table2DDS}
\title{table2DDS (aggregate function) called by ds.table2D}
\usage{
table2DDS(xvect, yvect)
}
\arguments{
\item{xvect}{a numerical vector with discrete values - usually a factor.}

\item{yvect}{a numerical vector with discrete values - usually a factor.}
}
\value{
a list which contains two elements: 'table', the 2-dimensional table and 'message' a message which
informs about the validity of the table.
}
\description{
This function generates a 2-dimensional contingency table where potentially disclosive cells
(based on a set threshold) are replaced by a missing value ('NA').
}
\details{
It generates 2-dimensional contingency tables where valid (non-disclosive) tables are defined
as those where none of their cells have counts between 1 and the set threshold "nfilter.tab". When the output table
is invalid all cells except the total counts are replaced by missing values. Only the total counts are visible
on the table returned to the client side. A message is also returned with the 2-dimensional table; the message
says "invalid table - invalid counts present" if the table is invalid and 'valid table' otherwise.
}
\author{
Amadou Gaye, Paul Burton, Demetris Avraam for DataSHIELD Development Team
}
