# Generated by 02-duckplyr_df-methods.R
#' @export
group_size.duckplyr_df <- function(x) {
  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for group_size()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  group_size <- dplyr$group_size.data.frame
  out <- group_size(x)
  return(out)

  # dplyr implementation
  lengths(group_rows(x))
}

duckplyr_group_size <- function(x, ...) {
  try_fetch(
    x <- as_duckplyr_df(x),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_size(x, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
