% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{nums_to_NA}
\alias{nums_to_NA}
\title{Replace numeric values in numeric columns with NA}
\usage{
nums_to_NA(data, ..., nums_to_replace = NULL)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}

\item{nums_to_replace}{numeric vector of values to be replaced with
\code{NA}. Case is ignored.}
}
\value{
\code{data} with specified values replaced with NA
}
\description{
Replaces specified numbers in numeric columns with \code{NA}.
}
\details{
Columns to process can be specified in \code{...} or the function will be
applied to all numeric columns.
}
\examples{
data(example_data)

# replace all 1,2, and 3 from tumoursize and patient_id with NA.
nums_to_NA(data = example_data, tumoursize, patient_id, nums_to_replace = c(1,2,3))
}
