% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryUtils.R
\encoding{UTF-8}
\name{trajectoryutils}
\alias{trajectoryutils}
\alias{trajectorySelection}
\alias{centerTrajectories}
\alias{is.metric}
\title{Utility functions for Ecological Trajectory Analysis}
\usage{
trajectorySelection(d, sites, selection)

centerTrajectories(d, sites, verbose = FALSE)

is.metric(d, tol = 1e-04)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of ecosystem states (see details).}

\item{sites}{A vector indicating the site corresponding to each ecosystem state.}

\item{selection}{A character vector of sites, a numeric vector of site indices or logical vector of the same length as \code{sites}, indicating a subset of site trajectories to be selected.}

\item{verbose}{Provides console output informing about process (useful for large dataset).}

\item{tol}{Tolerance value for metricity}
}
\value{
Function \code{centerTrajectories} and \code{trajectorySelection} return an object of class \code{\link{dist}}.
}
\description{
The set following set of utility functions are provided:
\itemize{
\item{Function \code{trajectorySelection} allows selecting the submatrix of distances corresponding to a given subset of trajectories.}
\item{Function \code{centerTrajectories} shifts all trajectories to the center of the compositional space and returns a modified distance matrix.}
\item{Function \code{is.metric} checks whether the input dissimilarity matrix is metric (i.e. all triplets fulfill the triangle inequality).}
}
}
\details{
Details of calculations are given in De \enc{Cáceres}{Caceres} et al (2019).
Function \code{centerTrajectories} performs centering of trajectories using matrix algebra as explained in Anderson (2017).
}
\references{
De \enc{Cáceres}{Caceres} M, Coll L, Legendre P, Allen RB, Wiser SK, Fortin MJ, Condit R & Hubbell S. (2019). Trajectory analysis in community ecology. Ecological Monographs 89, e01350.

Anderson (2017). Permutational Multivariate Analysis of Variance (PERMANOVA). Wiley StatsRef: Statistics Reference Online. 1-15. Article ID: stat07841.
}
\seealso{
\code{\link{trajectoryplots}} \code{\link{trajectorymetrics}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF
}
