% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{shifted_outcome}
\alias{shifted_outcome}
\title{Implements the shifted modified outcome approach}
\usage{
shifted_outcome(A, X, Y, propensity, parallel = FALSE, shift = 0.1,
  ...)
}
\arguments{
\item{A}{target variant}

\item{X}{rest of the genotype}

\item{Y}{phenotype}

\item{propensity}{propensity scores}

\item{parallel}{whether to perform support estimation in a
parallelized fashion}

\item{shift}{regularization term to be added to the propensity scores to
avoid numerical stability}

\item{...}{additional arguments to be passed to \code{stabilityGLM} or
\code{stabilityBIG}}
}
\value{
a vector containing the area under the stability selection path for
  each variable in \code{X}
}
\description{
Shifted modified outcome is an improvement to modified outcome. It is
a heuristic which consists in the addition of of a small translation term to
the inverse of the propensity score. The goal is to avoid numerical
instability due to low propensity scores values. More precisely, the
inverses of the propensity scores become
\eqn{1/(\pi(A| X) + \xi)}{1/(P(A|X) + shift)}. We recommend keeping
the default value of the parameter \eqn{\xi}{shift} at 0.1.
}
\examples{
\donttest{
n <- 30
p <- 10
X <- matrix((runif(n * p) < 0.5) + (runif(n * p) < 0.5),
             ncol = p, nrow = n) # SNP matrix
A <- (runif(n) < 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- runif(n) < 1/ (1 + exp(-X[, 2, drop = FALSE]))
shifted_scores <- shifted_outcome(A, X, Y, propensity,
                               shift = 0.1, n_subsample = 1)
}

}
