% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassification.R
\name{misclassification}
\alias{misclassification}
\title{Sensitivity analysis for disease or exposure misclassification.}
\usage{
misclassification(
  case,
  exposed,
  type = c("exposure", "exposure_pv", "outcome"),
  bias_parms = NULL,
  alpha = 0.05
)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{type}{Choice of misclassification:
\enumerate{
\item exposure: bias analysis for exposure misclassification; corrections using
sensitivity and specificity: nondifferential and independent errors,
\item exposure_pv: bias analysis for exposure misclassification; corrections using
PPV/NPV: nondifferential and independent errors,
\item outcome: bias analysis for outcome misclassification.
}}

\item{bias_parms}{Vector defining the bias parameters. This vector has 4 elements
between 0 and 1, in the following order:
\enumerate{
\item Sensitivity of exposure (when \code{type = "exposure"}) or outcome (when \code{type = "outcome"}) classification among those with the outcome (when \code{type = "exposure"}) or exposure (when \code{type = "outcome"}),
\item Sensitivity of exposure (or outcome) classification among those without the outcome (or exposure),
\item Specificity of exposure (or outcome) classification among those with the outcome (or exposure), and
\item Specificity of exposure (or outcome) classification among those without the outcome (or exposure).
}
If PPV/NPV is chosen in case of exposure misclassification, this vector is the following:
\enumerate{
\item Positive predictive value among those with the outcome,
\item Positive predictive value among those without the outcome,
\item Negative predictive value among those with the outcome,
\item Negative predictive value among those without the outcome.
}}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{corr.data}{The expected observed data given the true data assuming
misclassification.}
\item{obs.measures}{A table of observed relative risk and odds ratio with
confidence intervals.}
\item{adj.measures}{A table of adjusted relative risk and odds ratio with confidence
interval for odds ratio.}
\item{bias.parms}{Input bias parameters.}
}
\description{
Simple sensitivity analysis for disease or exposure misclassification.
Confidence interval for odds ratio adjusted using sensitivity and specificity is
computed as in Chu et al. (2006), for exposure misclassification.
}
\details{
For exposure misclassification, bias-adjusted measures are available using sensitivity
and specificity, or using predictive values.
}
\examples{
# The data for this example come from:
# Fink, A.K., Lash,  T.L. A null association between smoking during pregnancy
# and breast cancer using Massachusetts registry data (United States).
# Cancer Causes Control 2003;14:497-503.
misclassification(matrix(c(215, 1449, 668, 4296),
dimnames = list(c("Breast cancer+", "Breast cancer-"),
c("Smoker+", "Smoker-")),
nrow = 2, byrow = TRUE),
type = "exposure",
bias_parms = c(.78, .78, .99, .99))

misclassification(matrix(c(4558, 3428, 46305, 46085),
dimnames = list(c("AMI death+", "AMI death-"),
c("Male+", "Male-")),
nrow = 2, byrow = TRUE),
type = "outcome",
bias_parms = c(.53, .53, .99, .99))

# The following example comes from Chu et al. Sensitivity analysis of
# misclassification: A graphical and a Bayesian approach.
# Annals of Epidemiology 2006;16:834-841.
misclassification(matrix(c(126, 92, 71, 224),
dimnames = list(c("Case", "Control"), c("Smoker +", "Smoker -")),
nrow = 2, byrow = TRUE),
type = "exposure",
bias_parms = c(.94, .94, .97, .97))

# The next example, using PPV/NPV, comes from Bodnar et al. Validity of birth
# certificate-derived maternal weight data.
# Paediatric and Perinatal Epidemiology 2014;28:203-212.
misclassification(matrix(c(599, 4978, 31175, 391851),
dimnames = list(c("Preterm", "Term"), c("Underweight", "Normal weight")),
nrow = 2, byrow = TRUE),
type = "exposure_pv",
bias_parms = c(0.65, 0.74, 1, 0.98))
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.79--108, Springer.

Chu, H., Zhaojie, W., Cole, S.R., Greenland, S., \emph{Sensitivity analysis of
misclassification: A graphical and a Bayesian approach},
Annals of Epidemiology 2006;16:834-841.
}
