% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbias.R
\name{mbias}
\alias{mbias}
\title{Sensitivity analysis to correct for selection bias caused by M bias.}
\usage{
mbias(or, var = c("y", "x", "a", "b", "m"))
}
\arguments{
\item{or}{Vector defining the input bias parameters, in the following order:
\enumerate{
\item Odds ratio between A and the exposure E,
\item Odds ratio between A and the collider M,
\item Odds ratio between B and the collider M,
\item Odds ratio between B and the outcome D,
\item Odds ratio observed between the exposure E and the outcome D.
}}

\item{var}{Vector defining variable names, in the following order:
\enumerate{
\item Outcome,
\item Exposure,
\item A,
\item B,
\item Collider.
}}
}
\value{
A list with elements:
\item{model}{Bias analysis performed.}
\item{mbias.parms}{Three maximum bias parameters: in collider-exposure relationship
created by conditioning on the collider, in collider-outcome relationship created by
conditioning on the collider, and in exposure-outcome relationship created by
conditioning on the collider.}
\item{adj.measures}{Selection bias corrected odds ratio.}
\item{bias.parms}{Input bias parameters.}
\item{labels}{Variables' labels.}
}
\description{
Simple sensitivity analysis to correct for selection bias caused by M bias using
estimates of the odds ratios relating the variables.
}
\examples{
mbias(or = c(2, 5.4, 2.5, 1.5, 1),
var = c("HIV", "Circumcision", "Muslim", "Low CD4", "Participation"))
}
\references{
Greenland S. Quantifying biases in causal models: classical
confounding vs. collider-stratification bias. Epidemiology 2003;14:300-6.
}
\seealso{
Other selection: 
\code{\link{selection}()}
}
\concept{selection}
