% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPosteriorProbs.R
\name{plotPosteriorProbs}
\alias{plotPosteriorProbs}
\title{Plot Posterior Probabilities Across Thresholds for CRT, MST, or SRT Designs}
\usage{
plotPosteriorProbs(
  method = c("crt", "mst", "srt"),
  data,
  outcome = "posttest",
  interventions = "interventions",
  Random = "schools",
  Nsim = 10000,
  continuous_covariates = NULL,
  categorical_covariates = NULL,
  VerticalLine = NULL,
  VerticalLineColor = "#0000FF",
  HorizontalLine = NULL,
  HorizontalLineColor = "#FF0000",
  threshold_range = c(0, 1),
  maintitle = "Posterior Probabilities Across Thresholds",
  xlabel = "Threshold",
  ylabel = "Posterior Probability",
  intcolors = NULL,
  intlabels = NULL,
  xbreaks = NULL,
  ybreaks = seq(0, 1, by = 0.1)
)
}
\arguments{
\item{method}{The trial design type: "crt", "mst", or "srt".}

\item{data}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention.}

\item{outcome}{The name of the outcome (post-test) variable.}

\item{interventions}{A string specifying the intervention variable.}

\item{Random}{The name of the clustering variable (e.g., schools or sites) for CRT and MST designs.}

\item{Nsim}{Number of MCMC iterations to be performed. A minimum of 10,000 is recommended to ensure convergence.}

\item{continuous_covariates}{A character vector specifying the names of continuous covariates.}

\item{categorical_covariates}{A character vector specifying the names of categorical covariates (converted to factors).}

\item{VerticalLine}{Optional vertical reference line added at a threshold value. It should be specified as a numeric value.}

\item{VerticalLineColor}{The color of the vertical reference line. It should be specified as a character string (default = "#0000FF").}

\item{HorizontalLine}{Optional posterior probability cutoff for adding a horizontal reference line. It should be specified as a numeric value.}

\item{HorizontalLineColor}{The color of the horizontal reference line. It should be specified as a character string (default = "#FF0000").}

\item{threshold_range}{The range of thresholds to evaluate. It should be specified as a numeric vector of length 2 (default = c(0, 1.0)).}

\item{maintitle}{The main title of the plot.}

\item{xlabel}{The label for the x-axis.}

\item{ylabel}{The label for the y-axis.}

\item{intcolors}{Optional intervention colors specified manually. It should be provided as a named character vector.}

\item{intlabels}{Optional intervention labels to use instead of default names. It should be specified as a character vector.}

\item{xbreaks}{Tick marks for the x-axis. Must be a numeric vector with values within the specified threshold_range (default = 0.1).}

\item{ybreaks}{Tick marks for the y-axis. It should be specified as a numeric vector (default = seq(0, 1, by = 0.1)).}
}
\value{
A \code{ggplot} object that displays posterior probabilities across thresholds for each intervention.
}
\description{
This function generates a Bayesian posterior probability plot across multiple thresholds
for each intervention group in a clustered randomized trial (CRT), multisite trial (MST),
or simple randomized trial (SRT).
}
\details{
The function uses \code{crtBayes()}, \code{mstBayes()}, or \code{srtBayes()} from eefAnalytics package depending on the \code{method}.
}
\examples{
\donttest{

###Plot Posterior Probabilities of cluster randomized trial###
data(crt4armSimData)
plotPosteriorProbs(method = "crt",data = crt4armSimData, outcome = "posttest",
interventions = "interventions", Random = "schools", Nsim = 10000,
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
threshold_range = c(0, 0.1), VerticalLine = 0.05, HorizontalLine = 0.8,
VerticalLineColor= "purple", HorizontalLineColor= "black", 
intlabels = c("Intervention A", "Intervention B", "Intervention C"), 
intcolors = c("Intervention A" = "blue", "Intervention B" = "red", 
"Intervention C" = "green"), maintitle= "Posterior probability plot",
xlabel= "Threshold", ylabel= "Posterior probability",
xbreaks= 0.1, ybreaks= seq(0, 1, by = 0.1))

###Plot Posterior Probabilities of multisite trial###
data(mst4armSimData)
plotPosteriorProbs(method = "ms",data = mst4armSimData, outcome = "posttest", 
interventions = "interventions", Random = "schools", Nsim = 10000,
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
threshold_range = c(0, 0.1), VerticalLine = 0.05, HorizontalLine = 0.8, 
VerticalLineColor= "purple", HorizontalLineColor= "black",
intlabels = c("Intervention A", "Intervention B", "Intervention C"), 
intcolors = c("Intervention A" = "blue", "Intervention B" = "red",
"Intervention C" = "green"), maintitle= "Posterior probability plot",
xlabel= "Threshold", ylabel= "Posterior probability",
xbreaks= 0.1, ybreaks= seq(0, 1, by = 0.1))

###Futility analysis of simple randomized trial###
data(srt4armSimData)
plotPosteriorProbs(method = "srt",data = srt4armSimData, outcome = "posttest",
interventions = "interventions", Nsim = 10000, threshold_range = c(0, 0.2),
continuous_covariates = c("pretest"), categorical_covariates = c("gender", "ethnicity"),
VerticalLine = 0.05, HorizontalLine = 0.8, VerticalLineColor= "purple",
HorizontalLineColor= "black", intlabels = c("Intervention A", "Intervention B",
"Intervention C"), intcolors = c("Intervention A" = "#1F77B4", 
"Intervention B" = "#D62728", "Intervention C" = "#2CA02C"),
maintitle= "Posterior probability plot", xlabel= "Threshold", 
ylabel= "Posterior probability", xbreaks= 0.1, ybreaks= seq(0, 1, by = 0.1))
}

}
\seealso{
\code{\link[eefAnalytics]{crtBayes}}, \code{\link[eefAnalytics]{mstBayes}}, \code{\link[eefAnalytics]{srtBayes}} functions from the \pkg{eefAnalytics} package
}
