% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{eq5d3l}
\alias{eq5d3l}
\title{eq5d3l}
\usage{
eq5d3l(x, country = NULL, dim.names = c("mo", "sc", "ua", "pd", "ad"))
}
\arguments{
\item{x}{A vector of 5-digit EQ-5D-3L state indexes or a matrix/data.frame with columns corresponding to EQ-5D-3L state dimensions.}

\item{country}{String vector indicating country names or  ISO3166 Alpha 2 / 3 country codes.}

\item{dim.names}{A character vector specifying the names of the EQ-5D-3L dimensions.  Default is c("mo", "sc", "ua", "pd", "ad").}
}
\value{
A vector of EQ-5D-3L values or data.frame with one column for each value set requested.
}
\description{
Get EQ-5D-3L index values from individual responses to the five dimensions of the EQ-5D-3L.
}
\examples{
eq5d3l(c(11111, 12321, 32123, 33333), 'US') # US -3L value set
eq5d3l(make_all_EQ_states('3L'), c('DK', 'CA')) # Danish and Canada -3L value sets 
}
