% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_similarity_from_mesh.R
\name{sp.similarity.from.mesh}
\alias{sp.similarity.from.mesh}
\title{Distance-based spatial similarity metrics calculated from the mesh.
\loadmathjax}
\usage{
sp.similarity.from.mesh(
  mesh1,
  mesh2,
  hausdorff.coeff = c("HD.max", "HD.mean"),
  hausdorff.quantile = c(0.5, 0.95),
  surface.tol = seq(0, 10, 1)
)
}
\arguments{
\item{mesh1, mesh2}{espadon mesh class objects}

\item{hausdorff.coeff}{Vector indicating the requested Hausdorff distance metrics from among
'HD.max','HD.mean'. Equal to \code{NULL} if not requested.
\code{NULL}, it will be added.}

\item{hausdorff.quantile}{numeric vector of probabilities with values between 0 and 1,
representing the quantiles of the unsigned distances between \code{mesh1} and \code{mesh2}.
Equal to \code{NULL} if not requested.}

\item{surface.tol}{numeric vector representing the maximum margins of
deviation which may be tolerated without penalty. Equal to \code{NULL} if not requested.}
}
\value{
Returns a list containing (if requested):
\itemize{
\item \code{Hausdorff} : dataframe including the maximum, mean and quantiles
\item \code{smetrics} : dataframe with the columns:
\itemize{
\item \code{tol} : the requested tolerances
\item \code{sDSC} : the surface Dice similarity coefficients,defined by
\emph{Nikolov et al} \strong{[1]}
\item \code{sAPL} : the surface Added Path Length in \mjeqn{mm^{2}}{ascii},
introduced (in pixels) by  \emph{Vaassen et al} \strong{[2]}

}
}
}
\description{
The \code{sp.similarity.from.mesh} function computes Hausdorff
distances and surface Dice similarity coefficient.
}
\examples{
library (Rvcg)
# espadon mesh of two spheres of radius R1=10 and R2=11, separated by dR = 3
sph <- vcgSphere ()
mesh1 <- obj.create ("mesh")
mesh1$nb.faces <- ncol (sph$it)
mesh1$mesh <- sph
mesh2 <-  mesh1

R1 <- 10
R2 <- 11
dR <- 3
mesh1$mesh$vb[1:3,] <- R1 * mesh1$mesh$normals[1:3,] + mesh1$mesh$vb[1:3,]
mesh2$mesh$vb[1:3,] <- R2 * mesh2$mesh$normals[1:3,] + mesh2$mesh$vb[1:3,] +
                 matrix (c (dR, 0, 0), ncol = ncol (mesh2$mesh$vb), nrow = 3)
             
sp.similarity.from.mesh (mesh1 , mesh2, 
                         hausdorff.quantile = seq (0, 1, 0.05),
                         surface.tol = seq (0, dR + abs(R2-R1), 0.5))
}
\references{
\strong{[1]} \insertRef{Nikolov2018DeepLT}{espadon}

\strong{[2]} \insertRef{Vaassen2020Eval}{espadon}
}
\seealso{
\link[espadon]{sp.similarity.from.bin}
}
