% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_value_from_mesh.R
\name{get.value.from.mesh}
\alias{get.value.from.mesh}
\title{Voxel value at a given depth of a mesh}
\usage{
get.value.from.mesh(
  mesh,
  vol,
  method = c("point", "disk", "sphere"),
  depth = 0,
  radius = 5,
  spacing = 1,
  T.MAT = NULL,
  FUN = median,
  ...
)
}
\arguments{
\item{mesh}{espadon "mesh" class object, or rgl/Rvcg "mesh3d" class object. "mesh3d" class object
shall an additional field "ref.pseudo" specifying the mesh frame of reference.}

\item{vol}{"volume" class object.}

\item{method}{string specifying the desired method for retrieving measurements in \code{vol}.
by default "point". Other methods exist, for example "disk" or "sphere. See details.}

\item{depth}{Numeric value, representing the depth, relative to the surface
of the mesh, at which values are retrieved. 0 corresponds to the surface,
positive values enter the volume used to define the mesh and negative values leave it.}

\item{radius}{Positive number, defining the radius of the disk or sphere,
depending on the desired method.}

\item{spacing}{spacing of the measurement points on the disk or sphere.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.patient.from.dicom}, \link[espadon]{load.T.MAT} or \link[espadon]{ref.add}.}

\item{FUN}{function to be applied to reduce the data ("disk" or "sphere" method)
to a single value.
Default, median value.}

\item{...}{Additional arguments passed to \code{FUN} if needed.}
}
\value{
Returns a vector of values measured at the requested depth, with the
desired method, filtered by \code{FUN}, at each vertex of the mesh.
}
\description{
The \code{get.value.from.mesh} function is used to retrieve
the values of an object of class "volume" at the desired depth of a surface
described by a mesh. If the mesh corresponds to the "patient" contour,
the zero depth is the skin, positive depths enter the patient and negative depths exit to the outside.
}
\details{
The \code{get.value.from.mesh} function works at each vertex of the mesh.
It moves along the normal at that point to the desired depth.
\itemize{
\item When the method is "point", it simply retrieves the value of the volume
\code{vol} specified at that point.
\item When the method is "disk", the values are retrieved on the disk orthogonal
to the normal,with radius \code{radius}.
\item When the method is "sphere", the values are retrieved inside the sphere
of radius \code{radius}.
}
For "disk" or "sphere", the measurement points are
spaced by \code{spacing}. For \code{radius=5} and \code{spacing=1}, "disk" and "sphere" perform
78 and 523 measurements respectively.
In both cases, the measured values must be reduced to a single result using the
\code{FUN} function. By default, espadon uses the median, but it can be
provided with more complex functions to filter the data efficiently (see example below).
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 5
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "",
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# creation of the patient mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "patient", 
                     verbose = FALSE)
mesh.patient <- mesh.from.bin (bin, alias = "patient", verbose = FALSE)

# density value on the skin contour, extracted from CT
density <- get.value.from.mesh (mesh.patient, CT ,depth = 0) 

if (interactive()){
  # Display of mesh, with RVV pal
  density[density < -1000] <- -1000
  density[density > 1000] <- 1000
  col <- pal.RVV(255)[cut (density, seq (-1000, 1000, length.out = 256), 
                           include.lowest=TRUE)]
  rgl::open3d ()
  display.3D.mesh (mesh.patient, col = col)
}
}
