% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pet.R
\name{pet}
\alias{pet}
\title{Potential Evapotranspiration}
\usage{
pet(x, method = "od")
}
\arguments{
\item{x}{a RasterBrick object with average temperature data.}

\item{method}{a character string indicating the method to be used. Available options are:
\itemize{
\item{"bc" for Blaney and Criddle (1950),}
\item{"ha" for Hamon (1961),}
\item{"jh" for Jensen and Haise (1963),}
\item{"mb" for McGuinness and Bordne (1972),}
\item{"od" for Oudin (2005). Default,}
\item{"th" for Thornthwaite (1948).}
}}
}
\value{
a RasterBrick object with potential evapotranspiration in [mm/day].
}
\description{
The function \code{pet} estimates PET by different methods
}
\examples{
\donttest{
#Calculate PET by Oudin 
tavg <- raster::brick("terraclimate_tavg_land_19580101_20221231_025_monthly.nc")
pet_oudin <- pet(tavg, method = "od")
pet_oudin <- muldpm(pet_oudin)
}
}
