% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{ItemThreshold}
\alias{ItemThreshold}
\title{Item Threshold}
\usage{
ItemThreshold(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A numeric vector of threshold values for each item on the standard normal scale.
Typical values range from about -3 to 3, where:
\itemize{
\item Positive values indicate difficult items
\item Zero indicates items of medium difficulty (50\% correct)
\item Negative values indicate easy items
}
}
\description{
Item threshold is a measure of difficulty based on a standard normal distribution.
This function is applicable only to binary response data.

The threshold is calculated as:
\deqn{\tau_j = \Phi^{-1}(1-p_j)}
where \eqn{\Phi^{-1}} is the inverse standard normal distribution function
and \eqn{p_j} is the correct response rate for item j.

Higher threshold values indicate more difficult items, as they represent the
point on the standard normal scale above which examinees tend to answer incorrectly.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# using sample dataset
ItemThreshold(J5S10)
}
