% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch02TestItemAnalysis.R
\name{MutualInformation}
\alias{MutualInformation}
\title{Mutual Information}
\usage{
MutualInformation(U, na = NULL, Z = NULL, w = NULL, ...)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{...}{Internal parameters for maintaining compatibility with the binary data
processing system. Not intended for direct use.}
}
\value{
A matrix of mutual information values with exametrika class.
Each element (i,j) represents the mutual information between items i and j,
measured in bits. Higher values indicate stronger interdependence between items.
}
\description{
Mutual Information is a measure that represents the degree of interdependence
between two items. This function is applicable only to binary response data.
The measure is calculated using the joint probability distribution of responses
between item pairs and their marginal probabilities.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate Mutual Information using sample dataset J15S500
MutualInformation(J15S500)
}
