% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-confounds.R
\name{get_confounds_for_step}
\alias{get_confounds_for_step}
\title{Calculate confounds for a single pupil data step}
\usage{
get_confounds_for_step(pupil_df, pupil_vec, screen_width, screen_height, hz)
}
\arguments{
\item{pupil_df}{A data frame containing pupil data}

\item{pupil_vec}{A vector of pupil data for the current step}

\item{screen_width}{The screen width in pixels}

\item{screen_height}{The screen height in pixels}

\item{hz}{The sampling rate in Hz}
}
\value{
A data frame containing confounds metrics for the current step
}
\description{
Computes various metrics from pupil data including:
\itemize{
\item Blink detection
\item Gaze on/off screen detection
\item Gap analysis
\item Gaze distance from screen center
\item Gaze variance
\item Blink rate
\item Blink duration
\item Blink time
}
}
\keyword{internal}
