# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Column
#' @description Column Class
#' @format An \code{R6Class} generator object
#' @field defaultstatisticsids  list( character ) [optional]
#'
#' @field name  character [optional]
#'
#' @field directory  character [optional]
#'
#' @field category  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Column <- R6::R6Class(
  'Column',
  public = list(
    `defaultstatisticsids` = NULL,
    `name` = NULL,
    `directory` = NULL,
    `category` = NULL,
    initialize = function(`defaultstatisticsids`=NULL, `name`=NULL, `directory`=NULL, `category`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`defaultstatisticsids`)) {
        stopifnot(is.vector(`defaultstatisticsids`), length(`defaultstatisticsids`) != 0)
        sapply(`defaultstatisticsids`, function(x) stopifnot(is.character(x)))
        self$`defaultstatisticsids` <- `defaultstatisticsids`
      }
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`directory`)) {
        stopifnot(is.character(`directory`), length(`directory`) == 1)
        self$`directory` <- `directory`
      }
      if (!is.null(`category`)) {
        stopifnot(is.character(`category`), length(`category`) == 1)
        self$`category` <- `category`
      }
    },
    toJSON = function() {
      ColumnObject <- list()
      if (!is.null(self$`defaultstatisticsids`)) {
        ColumnObject[['defaultstatisticsids']] <-
          self$`defaultstatisticsids`
      }
      if (!is.null(self$`name`)) {
        ColumnObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`directory`)) {
        ColumnObject[['directory']] <-
          self$`directory`
      }
      if (!is.null(self$`category`)) {
        ColumnObject[['category']] <-
          self$`category`
      }

      ColumnObject
    },
    fromJSON = function(ColumnJson) {
      ColumnObject <- jsonlite::fromJSON(ColumnJson)
      if (!is.null(ColumnObject$`defaultstatisticsids`)) {
        self$`defaultstatisticsids` <- ApiClient$new()$deserializeObj(ColumnObject$`defaultstatisticsids`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(ColumnObject$`name`)) {
        self$`name` <- ColumnObject$`name`
      }
      if (!is.null(ColumnObject$`directory`)) {
        self$`directory` <- ColumnObject$`directory`
      }
      if (!is.null(ColumnObject$`category`)) {
        self$`category` <- ColumnObject$`category`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`defaultstatisticsids`)) {
        sprintf(
        '"defaultstatisticsids":
           [%s]
        ',
        paste(unlist(lapply(self$`defaultstatisticsids`, function(x) paste0('"', x, '"'))), collapse=",")
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`directory`)) {
        sprintf(
        '"directory":
          "%s"
                ',
        self$`directory`
        )},
        if (!is.null(self$`category`)) {
        sprintf(
        '"category":
          "%s"
                ',
        self$`category`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(ColumnJson) {
      ColumnObject <- jsonlite::fromJSON(ColumnJson)
      self$`defaultstatisticsids` <- ApiClient$new()$deserializeObj(ColumnObject$`defaultstatisticsids`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self$`name` <- ColumnObject$`name`
      self$`directory` <- ColumnObject$`directory`
      self$`category` <- ColumnObject$`category`
      self
    }
  )
)
