% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSpatialDepRast.r
\name{rSpatialDepRast,GRaster-method}
\alias{rSpatialDepRast,GRaster-method}
\alias{rSpatialDepRast}
\title{Create a random raster with or without spatial dependence}
\usage{
\S4method{rSpatialDepRast}{GRaster}(
  x,
  n = 1,
  mu = 0,
  sigma = 1,
  dist = 0,
  exponent = 1,
  delay = 0,
  seed = NULL
)
}
\arguments{
\item{x}{A \code{GRaster}: The output will have the same extent and dimensions as this raster.}

\item{n}{An integer: Number of rasters to generate.}

\item{mu, sigma}{Numeric: Mean and sample standard deviation of output. If creating more than one raster, you can provide one value per raster. If there are fewer, they will be recycled.}

\item{dist}{Numeric: Maximum distance of spatial autocorrelation (in map units--typically meters). Default is 0 (no spatial autocorrelation). If creating more than one raster, you can provide one value per raster. If there are fewer, values will be recycled.}

\item{exponent}{Numeric > 0: Distance decay exponent. If creating more than one raster, you can provide one value per raster. If there are fewer, values will be recycled.}

\item{delay}{Numeric >= 0: Values >0 force the distance decay of similarity to remain constant up to this distance. Beyond this distance, the decay exponent takes effect. Default is 0. If creating more than one raster, you can provide one value per raster. If there are fewer, values will be recycled.}

\item{seed}{Numeric integer or \code{NULL}: Random seed. If \code{NULL}, then a random seed is used for each raster. If provided, there should be one seed value per raster.}
}
\value{
A \code{GRaster}.
}
\description{
\code{rSpatialDepRast()} creates a raster with random values in cells. Across the raster, values are approximately normally distributed, though a raster with a "true" normal distribution can be made with \code{\link[=rnormRast]{rnormRast()}}. Spatial dependence can be introduced, though all together the values will still be approximately normally distributed.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

### Create a raster with values drawn from a uniform distribution:
unif <- runifRast(elev)
plot(unif)

### Create a raster with values drawn from a normal distribution:
norms <- rnormRast(elev, n = 2, mu = c(5, 10), sigma = c(2, 1))
plot(norms)
hist(norms, bins = 100)

# Create a raster with random, seemingly normally-distributed values:
rand <- rSpatialDepRast(elev, dist = 1000)
plot(rand)

# Values appear normal on first inspection:
hist(rand)

# ... but actually are patterned:
hist(rand, bins = 100)

# Create a fractal raster:
fractal <- fractalRast(elev, n = 2, dimension = c(2.1, 2.8))
plot(fractal)
hist(fractal)

}
}
\seealso{
\code{\link[=rnormRast]{rnormRast()}}, \code{\link[=fractalRast]{fractalRast()}}, \code{\link[=runifRast]{runifRast()}}, \strong{GRASS} manual page for module \code{r.random.surface} (see \code{grassHelp("r.random.surface")})
}
