% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitode-methods.R
\docType{methods}
\name{predict,fitode-method}
\alias{predict,fitode-method}
\title{Prediction function for fitode objects}
\usage{
\S4method{predict}{fitode}(
  object,
  level,
  times,
  method = c("delta", "impsamp", "wmvrnorm"),
  nsim = 1000
)
}
\arguments{
\item{object}{fitode object}

\item{level}{the confidence level required}

\item{times}{time vector to predict over. Default is set to the time frame of the data.}

\item{method}{confidence interval method. Default is set to Delta method.}

\item{nsim}{number of simulations for mvrnorm, wmvrnorm methods}
}
\value{
The estimated trajectories and their confidence intervals of the fitode object
}
\description{
Computes estimated trajectories and their confidence intervals (using either
the delta method or importance sampling).
}
