% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.plcfit.R
\name{plot.plcfit}
\alias{plot.plcfit}
\alias{plot.manyplcfit}
\title{Plot a fitted vulnerability curve}
\usage{
\method{plot}{plcfit}(x, xlab = NULL, ylab = NULL, ylim = NULL,
  pch = 19, plotPx = TRUE, plotci = TRUE, plotdata = TRUE,
  plotfit = TRUE, add = FALSE, multiplier = NULL,
  px_ci = c("bootstrap", "parametric", "none"),
  px_ci_type = c("vertical", "horizontal"), px_ci_label = TRUE,
  plotrandom = FALSE, pointcol = "black", linecol = "black",
  linetype = 1, linelwd = 1, linecol2 = "blue", pxlinecol = "red",
  pxcex = 0.7, citype = c("polygon", "lines"),
  cicol = alpha("lightgrey", 0.8), what = c("relk", "PLC", "embol"),
  selines = NULL, xaxis = c("positive", "negative"), ...)

\method{plot}{manyplcfit}(x, what = c("relk", "embol", "PLC"),
  onepanel = FALSE, linecol = NULL, pointcol = NULL, pch = 19,
  legend = TRUE, legendwhere = "topright", ...)
}
\arguments{
\item{x}{A fitted curve returned by \code{fitplc}}

\item{xlab, ylab}{Optionally, X and Y axis labels (if not provided, a default is used).}

\item{ylim}{Optionally, Y-axis limits.}

\item{pch}{Optionally, the plotting symbol (default = 19, filled circles)}

\item{plotPx}{Logical (default TRUE), whether to plot a vertical line for the P50.}

\item{plotci}{Logical (default TRUE), whether to plot the confidence interval (if computed with bootci=TRUE).}

\item{plotdata}{Logical (default TRUE), whether to add the data to the plot.}

\item{plotfit}{Logical (default TRUE), whether to add the fitted curve to the plot.}

\item{add}{Logical (default FALSE), whether to add the plot to a current device. This is useful to overlay two plots or curves, for example.}

\item{multiplier}{Multiply the scaled data (for plotting).}

\item{px_ci}{Option for the confidence interval around Px, either 'parametric' (confidence interval computed with \code{\link{confint}}), 'bootstrap' (computed with non-parametric bootstrap) or 'none' (no plotting of the confidence interval) (formerly argument was called \code{selines})}

\item{px_ci_type}{Either 'vertical' (default), or 'horizontal', to plot confidence limits for Px.}

\item{px_ci_label}{Logical (default TRUE), whether to write a label next to the CI for Px.}

\item{plotrandom}{Logical. If TRUE (the default is FALSE), plots the predictions for the random effects (only if random effects were included in the model fit).}

\item{pointcol}{The color(s) of the data points.}

\item{linecol}{The color(s) of the fitted curve (or color of the random effects curves if plotrandom=TRUE).}

\item{linetype}{Line type for fitted curve (see options for \code{lty} in \code{\link{par}}).}

\item{linelwd}{Width of the line (see options for \code{lwd} in \code{\link{par}}).}

\item{linecol2}{The color of the fixed effects curve (if plotrandom=TRUE; otherwise ignored).}

\item{pxlinecol}{The color of the lines indicating Px and its confidence interval}

\item{pxcex}{Character size for the Px label above the Y-axis.}

\item{citype}{Either 'polygon' (default), or 'lines', specifying formatting of the confidence interval in the plot.}

\item{cicol}{The color of the confidence interval band (if plotted).}

\item{what}{Either 'relk' or 'PLC' (or synonym 'embol'); it will plot either relative conductivity or percent loss conductivity (percent embolism).}

\item{selines}{Obsolete; use \code{px_ci}}

\item{xaxis}{Either 'positive' (default), so that water potential is plotted as positive values, or 'negative', plotting negative-valued water potentials.}

\item{\dots}{Further parameters passed to \code{plot}, or \code{points} (when \code{add=TRUE})}

\item{onepanel}{For plotting of many curve fits, plot all curves in one panel (TRUE) or in separate panels (FALSE)}

\item{legend}{(for fitconds and fitplcs only) Logical (default TRUE), whether to include a simple legend when plotting multiple fits}

\item{legendwhere}{(for fitconds and fitplcs only) As in \code{\link{legend}}, specification of where to place legend (e.g. 'bottomleft'; coordinates not accepted)}
}
\description{
Standard plots of fitted curves (objects returned by \code{\link{fitplc}}, \code{\link{fitplcs}}, \code{\link{fitcond}} or \code{\link{fitconds}}), with plenty of options for customization.
}
