% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_functions.R
\name{ffi_read_LIsmartchamber}
\alias{ffi_read_LIsmartchamber}
\title{Read a LI-8200-01S (smart chamber) data file}
\usage{
ffi_read_LIsmartchamber(file, concentrations = TRUE)
}
\arguments{
\item{file}{Filename to read, character}

\item{concentrations}{Return concentration data (the default), or
just summary information? Logical}
}
\value{
A \code{\link{data.frame}} with the parsed data.
}
\description{
Read a LI-8200-01S (smart chamber) data file
}
\note{
These files are in \href{https://www.json.org/json-en.html}{JSON} format.
See also \url{https://www.licor.com/env/products/soil-flux/smart-chamber}.
}
\examples{
f <- system.file("extdata/LI8200-01S.json", package = "fluxfinder")
dat <- ffi_read_LIsmartchamber(f) # returns 240 rows
ffi_read_LIsmartchamber(f, concentrations = FALSE) # only 4 rows
}
\author{
Ben Bond-Lamberty
}
