% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ideal-gas-law}
\alias{ideal-gas-law}
\alias{ffi_ppm_to_umol}
\alias{ffi_ppb_to_nmol}
\title{Convert gas concentration to quantity using the Ideal Gas Law}
\usage{
ffi_ppm_to_umol(ppm, volume, temp, atm)

ffi_ppb_to_nmol(ppb, volume, temp, atm)
}
\arguments{
\item{ppm}{Gas concentration (ppmv), numeric}

\item{volume}{System volume (chamber + tubing + analyzer, m3), numeric}

\item{temp}{Optional chamber temperature (degrees C), numeric}

\item{atm}{Optional atmospheric pressure (Pa), numeric}

\item{ppb}{Gas concentration (ppbv), numeric}
}
\value{
The quantity value, in micromoles (for \code{ffi_ppm_to_umol})
or nanomoles (for \code{ffi_ppb_to_nmol}).
}
\description{
Convert gas concentration to quantity using the Ideal Gas Law
}
\note{
If \code{temp} and/or \code{atm} are not provided, the defaults
are NIST normal temperature and pressure.
}
\examples{
ffi_ppm_to_umol(400, 0.1)
ffi_ppb_to_nmol(400, 0.1)
}
\references{
Steduto et al.:
Automated closed-system canopy-chamber for continuous field-crop monitoring
of CO2 and H2O fluxes, Agric. For. Meteorol., 111:171-186, 2002.
\doi{10.1016/S0168-1923(02)00023-0}
}
