% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_calc.R
\name{flux_calc}
\alias{flux_calc}
\title{Calculates ecosystem gas fluxes}
\usage{
flux_calc(
  slopes_df,
  slope_col,
  f_datetime = f_datetime,
  temp_air_col,
  chamber_volume,
  atm_pressure,
  plot_area,
  f_fluxid = f_fluxid,
  conc_unit,
  flux_unit,
  cols_keep = c(),
  cols_ave = c(),
  cols_sum = c(),
  cols_med = c(),
  tube_volume,
  temp_air_unit = "celsius",
  f_cut = f_cut,
  keep_arg = "keep",
  cut = TRUE,
  fit_type = c()
)
}
\arguments{
\item{slopes_df}{dataframe of flux slopes}

\item{slope_col}{column containing the slope to calculate the flux}

\item{f_datetime}{column containing the datetime of each gas concentration
measurements in \code{slopes_df}. The first one after cutting will be kept as
datetime of each flux in the output.}

\item{temp_air_col}{column containing the air temperature used
to calculate fluxes. Will be averaged with NA removed.}

\item{chamber_volume}{volume of the flux chamber in L,
can also be a column in case it is a variable}

\item{atm_pressure}{atmospheric pressure,
can be a constant (numerical) or a variable (column name)}

\item{plot_area}{area of the plot in m^2,
can also be a column in case it is a variable}

\item{f_fluxid}{column containing the flux IDs}

\item{conc_unit}{unit in which the concentration of gas was measured
\code{ppm} or \code{ppb}}

\item{flux_unit}{unit in which the calculated flux will be:
\code{mmol} outputs fluxes in
\ifelse{html}{\out{mmol * m<sup>-2</sup> * h<sup>-1</sup>}}{\eqn{mmol*m^{-2}*h^{-1}}{ASCII}}
; \code{micromol} outputs fluxes in
\ifelse{html}{\out{micromol * m<sup>-2</sup> * h<sup>-1</sup>}}{\eqn{micromol*m^{-2}*h^{-1}}{ASCII}}}

\item{cols_keep}{columns to keep from the input to the output.
Those columns need to have unique values for each flux,
as \link[dplyr:distinct]{distinct} is applied.}

\item{cols_ave}{columns with values that should be averaged
for each flux in the output. Note that NA are removed in mean calculation.}

\item{cols_sum}{columns with values for which is sum is provided
for each flux in the output. Note that NA are removed in sum calculation.}

\item{cols_med}{columns with values for which is median is provided
for each flux in the output. Note that NA are removed in median calculation.}

\item{tube_volume}{volume of the tubing in L,
can also be a column in case it is a variable}

\item{temp_air_unit}{units in which air temperature was measured.
Has to be either \code{celsius} (default), \code{fahrenheit} or \code{kelvin.}}

\item{f_cut}{column containing cutting information}

\item{keep_arg}{name in \code{f_cut} of data to keep}

\item{cut}{if 'TRUE' (default), the measurements will be cut according to
'f_cut' before calculating fluxes. This has no influence on the flux itself
since the slope is provided from \link[fluxible:flux_fitting]{flux_fitting},
but it will influence the values of the columns in \code{cols_ave}.}

\item{fit_type}{(optional) model used in
\link[fluxible:flux_fitting]{flux_fitting}. Will be automatically filled if
\code{slopes_df} was produced using \link[fluxible:flux_fitting]{flux_fitting}.}
}
\value{
a dataframe containing flux IDs, datetime of measurements' starts,
fluxes in
\ifelse{html}{\out{mmol * m<sup>-2</sup> * h<sup>-1</sup>}}{\eqn{mmol*m^{-2}*h^{-1}}{ASCII}}
or
\ifelse{html}{\out{micromol * m<sup>-2</sup> * h<sup>-1</sup>}}{\eqn{micromol*m^{-2}*h^{-1}}{ASCII}}
(\code{f_flux}) according to \code{flux_unit}, temperature average for each flux in
Kelvin (\code{f_temp_ave}), the total volume of the setup for each measurement
(\code{f_volume_setup}), the model used in
\link[fluxible:flux_fitting]{flux_fitting}, any column specified in
\code{cols_keep}, any column specified in \code{cols_ave} with
their value averaged over the measurement after cuts and discarding NA.
}
\description{
Calculates a flux based on the rate of change
of gas concentration over time
}
\examples{
data(co2_conc)
slopes <- flux_fitting(co2_conc, conc, datetime, fit_type = "exp_zhao18")
flux_calc(slopes,
f_slope,
datetime,
temp_air,
conc_unit = "ppm",
flux_unit = "mmol",
chamber_volume = 24.5,
tube_volume = 0.075,
atm_pressure = 1,
plot_area = 0.0625)
}
