% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdrn_metrics.R
\name{sdrn_metrics}
\alias{sdrn_metrics}
\title{sdrn_metrics}
\usage{
sdrn_metrics(forest_df, group_var, inv_time)
}
\arguments{
\item{forest_df}{Data frame containing the forest monitoring data.}

\item{group_var}{String. The name of the column used to group the data, that could be "plot" or "spp".}

\item{inv_time}{Numeric. The time interval between the two monitoring periods.}
}
\value{
A list containing the following metrics:
  - n_sur: Number of surviving trees per group.
  - n_death: Number of dead trees per group.
  - n_rec: Number of recruited trees per group.
  - n_n0: Total number of trees at the start of the interval per group.
  - n_n1: Total number of trees at the end of the interval per group.
  - death_rate: Annual death rate per group (%).
  - rec_rate: Annual recruitment rate per group (%).
  - nc_rate: Net change rate of tree count per group (%).
  - turn: Turnover rate, calculated as the mean of death and recruitment rates (%).
}
\description{
Calculates survival, death, and recruitment metrics for forest monitoring data over time.
}
