% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_datasets.R
\docType{data}
\name{study_region_bw}
\alias{study_region_bw}
\title{Bigwoods forest study region boundary}
\format{
A \code{sf} spatial features polygon
}
\usage{
study_region_bw
}
\description{
Boundary region for Bigwoods defined in terms of (x,y) vertices of a polygon.
}
\examples{
library(ggplot2)
library(sf)

# Convert all 2008 plot stems to sf object
census_2008_bw_sf <- census_2008_bw \%>\%
  st_as_sf(coords = c("gx", "gy"))

# Plot stems with plot boundary
ggplot() +
  geom_sf(data = census_2008_bw_sf, size = 0.25) +
  geom_sf(data = study_region_bw, color = "red", fill = "transparent")
}
\seealso{
Other Big Woods data: 
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{species_bw}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_ex}}
}
\concept{Big Woods data}
\concept{example data objects}
\keyword{datasets}
