library(fredr)
context("Endpoint functions: Tags")

test_that("fredr_tags()", {
  skip_if_no_key()
  expect_silent(tags <- fredr_tags(limit = 20L))
  expect_s3_class(tags, c("tbl_df", "tbl", "data.frame"))
  expect_true(ncol(tags) == 6)
  expect_true(nrow(tags) == 20)
})

test_that("fredr_related_tags()", {
  skip_if_no_key()
  expect_silent(tags <- fredr_related_tags(tag_names = "gdp", limit = 20L))
  expect_s3_class(tags, c("tbl_df", "tbl", "data.frame"))
  expect_error(fredr_related_tags())
  expect_error(fredr_related_tags(foo = "bar"))
  expect_error(fredr_related_tags(tag_names = "xyz"))
  expect_error(fredr_related_tags(tag_names = 1))
  expect_error(fredr_related_tags(tag_names = c("a", "b")))
  expect_true(ncol(tags) == 6)
  expect_true(nrow(tags) == 20)
})

test_that("fredr_tags_series()", {
  skip_if_no_key()
  expect_silent(tags <- fredr_tags_series(tag_names = "gdp", limit = 20L))
  expect_s3_class(tags, c("tbl_df", "tbl", "data.frame"))
  expect_error(fredr_tags_series())
  expect_error(fredr_tags_series(foo = "bar"))
  expect_error(fredr_tags_series(tag_names = "xyz"))
  expect_error(fredr_tags_series(tag_names = 1))
  expect_error(fredr_tags_series(tag_names = c("a", "b")))
  expect_true(ncol(tags) == 16)
  expect_true(nrow(tags) == 20)
})
