% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_path_complete.R
\name{get_path_complete}
\alias{get_path_complete}
\title{Get Complete Paths from a Dendrogram}
\usage{
get_path_complete(minidend, window_data, min_card, worker_number)
}
\arguments{
\item{minidend}{A dendrogram structure from which to derive paths. This should be created from 
a hierarchical clustering result.}

\item{window_data}{A data frame or matrix containing the data associated with the nodes in the dendrogram. 
This data is used for path recommendations.}

\item{min_card}{An integer specifying the minimum number of leaves (or nodes) that must be present 
in a path for it to be considered valid.}

\item{worker_number}{An integer representing the number of worker nodes to be used for parallel processing.}
}
\value{
A list where each element contains the recommended paths for the corresponding node in the dendrogram. 
        Each path includes information about the nodes and their associated scores.
}
\description{
This function computes recommended paths from a dendrogram structure using parallel processing. 
It utilizes the `find_recommended_path` function to identify optimal paths based on a minimum 
cardinality constraint, distributing the computation across multiple worker nodes.
}
\details{
The function creates a cluster of worker nodes, loads necessary libraries, and exports required 
variables and functions to each worker. It then applies the `find_recommended_path` function 
in parallel to the leaves of the provided dendrogram, gathering results into a single list. 
Finally, the cluster is stopped, and the results are returned.
}
