% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntheticPool.R
\name{syntheticPool}
\alias{syntheticPool}
\title{Pool estimates and variances obtained by analysing multiple synthetic datasets}
\usage{
syntheticPool(fits)
}
\arguments{
\item{fits}{Collection of model fits produced by a call of the form
\code{with(imps, lm(y~regime))} where \code{imps} is a collection of imputed datasets
of class \code{mids}.}
}
\value{
A matrix containing the pooled results.
}
\description{
This function pools estimates and variances which have been obtained by
analysing multiple synthetic imputations (e.g. created used \link{gFormulaImpute})
using the method developed by Raghunathan et al 2003.
}
\details{
The only argument to \code{syntheticPool} is a set of model fits obtained by running
an analysis on an imputed dataset collection of class \code{mids}, as created
for example using the \code{mice} function in the \code{mice} package.

The function returns a table containing the overall parameter estimates, the within, between and total imputation
variances, 95\% confidence intervals, and p-values testing the null hypothesis
that the corresponding parameters equal zero.

It is possible for the variance estimator developed by Raghunathan et al 2003 to
be negative. In this case \code{syntheticPool} stops and informs you to re-impute
using a larger number of imputations \code{M} and/or \code{nSim}.

The development of the \code{gFormulaMI} package was supported by a grant from the UK
Medical Research Council (MR/T023953/1).
}
\examples{
set.seed(7626)
#impute synthetic datasets under two regimes of interest using gFormulaImpute
imps <- gFormulaImpute(data=simDataFullyObs,M=10,
                        trtVars=c("a0","a1","a2"),
                        trtRegimes=list(c(0,0,0),c(1,1,1)))
#fit linear model to final outcome with regime as covariate
fits <- with(imps, lm(y~factor(regime)))
#pool results using Raghunathan et al 2003 rules
syntheticPool(fits)

}
\references{
Raghunathan TE, Reiter JP, Rubin DB. 2003. Multiple imputation for statistical
disclosure limitation. Journal of Official Statistics, 19(1), p.1-16.
}
\author{
Jonathan Bartlett \email{jonathan.bartlett1@lshtm.ac.uk}
}
