% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_utilities.R
\name{graph_vpar}
\alias{graph_vpar}
\alias{vchi}
\alias{vchiMAT}
\alias{vpar}
\alias{vparMAT}
\title{List of vertices and their parents for graph.}
\usage{
vchi(object, getv = TRUE, forceCheck = TRUE)

vchiMAT(object, getv = TRUE, forceCheck = TRUE)

vpar(object, getv = TRUE, forceCheck = TRUE)

vparMAT(object, getv = TRUE, forceCheck = TRUE)
}
\arguments{
\item{object}{An object representing a graph. Valid objects are an
adjacency matrix or an igraph.}

\item{getv}{The result is by default a list of vectors of the form
\code{(v, pa1, pa2, ... paN)} where \code{pa1, pa2, ... paN}
are the parents of \code{v}. If \code{getv} is \code{FALSE}
then the vectors will have the form \code{(pa1, pa2, ... paN)}}

\item{forceCheck}{Logical indicating if it should be checked that
the object is a DAG.}
}
\value{
A list of vectors where each vector will have the form
\code{(v, pa1, pa2, ... paN)} where \code{pa1, pa2, ... paN}
are the parents of \code{v}.
}
\description{
Get list of vertices and their parents for graph.
}
\examples{

## DAGs
dag_mat <- dag(~a:b:c + c:d:e, result="matrix")
dag_ig <- dag(~a:b:c + c:d:e)
vpar(dag_mat)
vpar(dag_ig)
vpar(dag_mat, getv=FALSE)
vpar(dag_ig, getv=FALSE)
## Undirected graphs
ug_mat <- ug(~a:b:c + c:d:e, result="matrix")
ug_ig <- ug(~a:b:c + c:d:e)
\dontrun{
## This will fail because the adjacency matrix is symmetric and the
## graph has undirected edges
vpar(ug_mat)
vpar(ug_ig)
}
## When forceCheck is FALSE, it will not be detected that the
#g raphs are undirected.
vpar(ug_mat, forceCheck=FALSE)
vpar(ug_ig, forceCheck=FALSE)
}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
