% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expr-generics.R, R/Expr-methods.R
\docType{methods}
\name{RtExpr}
\alias{RtExpr}
\alias{RtExpr,character,character-method}
\title{RtExpr.}
\usage{
RtExpr(object, comparator, operand)

\S4method{RtExpr}{character,character}(object, comparator, operand)
}
\arguments{
\item{object}{A dimension or metric variable, or another object to be coerced
to an .expr object.}

\item{comparator}{The comparator to use for the expression.}

\item{operand}{The operand to use for the expression.}
}
\description{
Create a Real-Time Reporting API expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = character,comparator = character}: Define a Real-Time Reporting condition using the arguments
describing the variable, comparator and operand.
}}

\examples{
\donttest{
  myQuery <- RtQuery(view = 123456789)
  source_matches_google <- RtExpr("rt:source", "~", "google")
  TableFilter(myQuery) <- source_matches_google
}

}
\seealso{
Other expression generators: \code{\link{Expr}},
  \code{\link{GaExpr}}, \code{\link{McfExpr}}
}
