% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gc_smooth.spline}
\alias{gc_smooth.spline}
\title{Fit a Smoothing Spline}
\usage{
gc_smooth.spline(x, y = NULL, ..., na.rm = TRUE)
}
\arguments{
\item{x}{A vector giving the values of the predictor variable.}

\item{y}{A vector giving the values of the response variable. If \code{y} is
missing or \code{NULL}, the responses are assumed to be specified
by \code{x}, with \code{x} the index vector.}

\item{...}{Additional arguments passed to \link{smooth.spline}.}

\item{na.rm}{logical whether NA's should be removed before analyzing.
Required to be TRUE if any \code{x} or \code{y} values are NA.}
}
\value{
Similar to \link{smooth.spline}, an object of class 
        "\code{smooth.spline}" with many components. Differs in that
        x, y, and w have NA's at any indices where \code{x} or \code{y} were 
        NA in the inputs, and x, y, and w are returned to match the input 
        \code{x} in order and length
}
\description{
This function is a wrapper for \link{smooth.spline}, which fits 
a cubic smoothing spline to the supplied data, but includes the option
to remove \code{NA} values, and returns values in the original order.
}
\details{
See \link{smooth.spline}
}
