% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogr_define.R
\name{ogr_define}
\alias{ogr_define}
\alias{ogr_def_field}
\alias{ogr_def_geom_field}
\alias{ogr_def_layer}
\title{OGR feature class definition for vector data}
\usage{
ogr_def_field(
  fld_type,
  fld_subtype = NULL,
  fld_width = NULL,
  fld_precision = NULL,
  is_nullable = NULL,
  is_unique = NULL,
  is_ignored = NULL,
  default_value = NULL
)

ogr_def_geom_field(
  geom_type,
  srs = NULL,
  is_nullable = NULL,
  is_ignored = NULL
)

ogr_def_layer(geom_type, geom_fld_name = "geom", srs = NULL)
}
\arguments{
\item{fld_type}{Character string containing the name of a field data type
(e.g., \code{OFTInteger}, \code{OFTReal}, \code{OFTString}).}

\item{fld_subtype}{Character string containing the name of a field subtype.
One of  \code{OFSTNone} (the default), \code{OFSTBoolean}, \code{OFSTInt16}, \code{OFSTFloat32},
\code{OFSTJSON}, \code{OFSTUUID}.}

\item{fld_width}{Optional integer scalar specifying max number of characters.}

\item{fld_precision}{Optional integer scalar specifying number of digits
after the decimal point.}

\item{is_nullable}{Optional NOT NULL field constraint (logical scalar).
Defaults to \code{TRUE}.}

\item{is_unique}{Optional UNIQUE constraint on the field (logical scalar).
Defaults to \code{FALSE}.}

\item{is_ignored}{Whether field is ignored when retrieving features (logical
scalar). Defaults to \code{FALSE}.}

\item{default_value}{Optional default value for the field as a character
string.}

\item{geom_type}{Character string specifying a geometry type (see Details).}

\item{srs}{Character string containing a spatial reference system definition
as OGC WKT or other well-known format (e.g., the input formats usable with
\code{\link[=srs_to_wkt]{srs_to_wkt()}}).}

\item{geom_fld_name}{Character string specifying a geometry field name
Defaults to \code{"geometry"}.}
}
\description{
This topic contains documentation and helper functions for defining an
OGR feature class.
\code{ogr_def_field()} creates an attribute field definition, a list
containing the field data type and potentially other optional field
properties.
\code{ogr_def_geom_field()} similarly creates a geometry field definition.
A list containing zero or more attribute field definitions, along with one
or more geometry field definitions, comprise an OGR feature class definition
(a.k.a. layer definition). \code{ogr_def_layer()} initializes such a list with a
geometry field. Attribute fields can be added to a feature class definition
with calls to \code{ogr_def_field()} as in the examples.
}
\details{
All features in an OGR Layer share a common schema (feature class), modeled
in GDAL as OGR Feature Definition. The feature class definition includes the
set of attribute fields and their data types and the geometry field(s).
In R, a feature class definition is represented as a list, having as names
the attribute/geometry field names, with each list element holding a field
definition.

An attribute field definition is a list with named elements:

\if{html}{\out{<div class="sourceCode">}}\preformatted{$type       : OGR Field Type ("OFTReal", "OFTString" etc.)
$subtype    : optional ("OFSTBoolean", ...)
$width      : optional max number of characters
$precision  : optional number of digits after the decimal point
$is_nullable: optional NOT NULL constraint (logical scalar)
$is_unique  : optional UNIQUE constraint (logical scalar)
$default    : optional default value as character string
$is_ignored : optionally ignored when retrieving features (logical scalar)
$is_geom    : FALSE (the default) for attribute fields
}\if{html}{\out{</div>}}

An OGR field type is specified as a character string with possible values:
\code{OFTInteger}, \code{OFTIntegerList}, \code{OFTReal}, \code{OFTRealList}, \code{OFTString},
\code{OFTStringList}, \code{OFTBinary},  \code{OFTDate}, \code{OFTTime}, \code{OFTDateTime},
\code{OFTInteger64}, \code{OFTInteger64List}.

An optional field subtype is specified as a character string with possible
values:
\code{OFSTNone}, \code{OFSTBoolean}, \code{OFSTInt16}, \code{OFSTFloat32}, \code{OFSTJSON},
\code{OFSTUUID}.

By default, fields are nullable, have no unique constraint, and are not
ignored (i.e., not omitted when fetching features). Not-null and unique
constraints are not supported by all format drivers.

A default field value is taken into account by format drivers (generally
those with a SQL interface) that support it at field creation time.
If given in the field definition, \verb{$default} must be a character string.
The accepted values are \code{"NULL"}, a numeric value (e.g., \code{"0"}), a literal
value enclosed between single quote characters (e.g., \code{"'a default value'"},
with any inner single quote characters escaped by repetition of the single
quote character), \code{"CURRENT_TIMESTAMP"}, \code{"CURRENT_TIME"}, \code{"CURRENT_DATE"}
or a driver-specific expression (that might be ignored by other drivers).
For a datetime literal value, format should be
\code{"'YYYY/MM/DD HH:MM:SS[.sss]'"} (considered as UTC time).

A geometry field definition is a list with named elements:

\if{html}{\out{<div class="sourceCode">}}\preformatted{$type       : geom type ("Point", "Polygon", etc.)
$srs        : optional spatial reference as WKT string
$is_nullable: optional NOT NULL constraint (logical scalar)
$is_ignored : optionally ignored when retrieving features (logical scalar)
$is_geom    : TRUE (required) for geometry fields
}\if{html}{\out{</div>}}

Typically, there is one geometry field on a layer, but some formats support
more than one geometry column per table (e.g., PostGIS).

Geometry types are specified as a character string containing OGC WKT.
Common types include: \code{Point}, \code{LineString}, \code{Polygon}, \code{MultiPoint},
\code{MultiLineString}, \code{MultiPolygon}. See the GDAL documentation for a list
of all supported geometry types:\cr
\url{https://gdal.org/en/stable/api/vector_c_api.html#_CPPv418OGRwkbGeometryType}

Format drivers may or may not support not-null constraints on attribute and
geometry fields. If they support creating fields with not-null constraints,
this is generally before creating any features to the layer. In some cases,
a not-null constraint may be available as a layer creation option. For
example, GeoPackage format has a layer creation option
\verb{GEOMETRY_NULLABLE=[YES/NO]}.
}
\note{
The feature id (FID) is a special property of a feature and not treated as
an attribute of the feature. Additional information is given in the GDAL
documentation for the
\href{https://gdal.org/en/stable/user/ogr_sql_dialect.html#feature-id-fid}{OGR SQL} and
\href{https://gdal.org/en/stable/user/sql_sqlite_dialect.html#feature-id-fid}{SQLite}
SQL dialects. Implications for SQL statements and result sets may depend
on the dialect used.

Some vector formats do not support schema definition prior to creating
features. For example, with GeoJSON only the \emph{Feature} object has a member
with name \emph{properties}. The specification does not require all \emph{Feature}
objects in a collection to have the same schema of properties, nor does
it require all \emph{Feature} objects in a collection to have geometry of the
same type (\url{https://geojson.org/}).
}
\examples{
dsn <- file.path(tempdir(), "test.sqlite")
opt <- NULL
if (has_spatialite())
  opt <- "SPATIALITE=YES"
ogr_ds_create("SQLite", dsn, dsco = opt)

# define a layer
defn <- ogr_def_layer("Point", srs = epsg_to_wkt(4326))
defn$fld1_int64 <- ogr_def_field("OFTInteger64")
defn$fld2_string <- ogr_def_field("OFTString")

if (ogr_ds_test_cap(dsn)$CreateLayer)
  ogr_layer_create(dsn, "layer1", layer_defn = defn)

ogr_ds_layer_names(dsn)
ogr_layer_field_names(dsn, "layer1")

deleteDataset(dsn)
}
\seealso{
\code{\link[=ogr_ds_create]{ogr_ds_create()}}, \code{\link[=ogr_layer_create]{ogr_layer_create()}}, \code{\link[=ogr_field_create]{ogr_field_create()}}, \code{\link[=ogrinfo]{ogrinfo()}}

WKT representation of geometry:\cr
\url{https://en.wikipedia.org/wiki/Well-known_text_representation_of_geometry}
}
