% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_stat_qc.R
\name{stat_QC_labels}
\alias{stat_QC_labels}
\title{Write QC Line Labels to ggplot QC Charts.}
\usage{
stat_QC_labels(mapping = NULL, data = NULL, geom = "label",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, n = NULL, digits = 1, method = "xBar.rBar",
  color.qc_limits = "red", color.qc_center = "black", text.size = 3,
  physical.limits = c(NA, NA), limit.txt.label = c("LCL", "UCL"), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{n}{number, for
\itemize{
  \item \bold{Studentized Charts}, used for custom or hypothetical subgroup size.
  \item \bold{np Charts}, used to specify a fixed area of opportunity.
}}

\item{digits}{integer, indicating the number of decimal places}

\item{method}{string, calling the following methods:
\itemize{
\item \bold{Individuals Charts}: mR, XmR,
\item \bold{Attribute Charts}: c, np, p, u,
\item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian
\item \bold{Dispersion Charts}: rBar, rMedian, sBar.
}}

\item{color.qc_limits}{color, used to colorize the plot's upper and lower mR control limits.}

\item{color.qc_center}{color, used to colorize the plot's center line.}

\item{text.size}{number, size of the text label}

\item{physical.limits}{vector, specify lower physical boundary and upper physical boundary}

\item{limit.txt.label}{vector, provides option for naming or not showing the limit text labels (e.g., UCL, LCL)
\itemize{
\item \bold{limit.txt.label = c("LCL", "UCL")}: default
\item \bold{limit.txt.label = c("Low", "High")}: changes the label text to low and high
\item \bold{limit.txt.label = NA}: does not show label text.
}}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
data need to produce the mR plot in ggplot.
}
\description{
Write QC line labels to ggplot QC Charts. Useful if you want
to see the value of the center line and QC limits. see method argument
for methods supported.
}
\examples{
#########################
#  Example 1: mR Chart  #
#########################

# Load Libraries ----------------------------------------------------------
 require(ggQC)
 require(ggplot2)

# Setup Data --------------------------------------------------------------
 set.seed(5555)
 Process1 <- data.frame(processID = as.factor(rep(1,100)),
                        metric_value = rnorm(100,0,1),
                        subgroup_sample=rep(1:20, each=5),
                        Process_run_id = 1:100)
 set.seed(5556)
 Process2 <- data.frame(processID = as.factor(rep(2,100)),
                        metric_value = rnorm(100,5, 1),
                        subgroup_sample=rep(1:10, each=10),
                        Process_run_id = 101:200)

 Both_Processes <- rbind(Process1, Process2)

# Facet Plot - Both Processes ---------------------------------------------
EX1.1 <- ggplot(Both_Processes, aes(x=Process_run_id, y = metric_value)) +
 geom_point() + geom_line() + stat_QC(method="XmR") +
 stat_QC_labels(method="XmR", digits = 2) +
 facet_grid(.~processID, scales = "free_x")
#EX1.1

EX1.2 <- ggplot(Both_Processes, aes(x=Process_run_id, y = metric_value)) +
 stat_mR() + ylab("Moving Range") +
 stat_QC_labels(method="mR", digits = 2) +
 facet_grid(.~processID, scales = "free_x")
#EX1.2

#############################
#  Example 2:  XbarR Chart  #
#############################
# Facet Plot - Studentized Process ----------------------------------------

EX2.1 <- ggplot(Both_Processes, aes(x=subgroup_sample,
                          y = metric_value,
                          group = processID)) +
 geom_point(alpha=.2) +
 stat_summary(fun.y = "mean", color="blue", geom=c("point")) +
 stat_summary(fun.y = "mean", color="blue", geom=c("line")) +
 stat_QC() + facet_grid(.~processID, scales = "free_x") +
 stat_QC_labels(text.size =3, label.size=.1)
#EX2.1

EX2.2 <- ggplot(Both_Processes, aes(x=subgroup_sample,
                          y = metric_value,
                          group = processID)) +
 stat_summary(fun.y = "QCrange", color="blue", geom = "point") +
 stat_summary(fun.y = "QCrange", color="blue", geom = "line") +
 stat_QC(method="rBar") +
 stat_QC_labels(digits=2, method="rBar") +
 ylab("Range") +
 facet_grid(.~processID, scales = "free_x")
 #EX2.2
}
