% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{xBar_rBar_LCL}
\alias{xBar_rBar_LCL}
\title{Mean of Subgroup Means Lower Control Limit (LCL)}
\usage{
xBar_rBar_LCL(data, value, grouping, n = NULL, natural = F,
  formula = NULL)
}
\arguments{
\item{data}{data frame to be processed}

\item{value}{numeric vector in a data frame with values of interest.}

\item{grouping}{single factor/variable to split the data frame "values" by.}

\item{n}{a number indicating a hypothetical subgroup size other than, function determined subgroup n
determined by the floor length of subgroup values.}

\item{natural}{logical, if TRUE calculate limits for individuals (n=1) else calculate for
n determined by the floor length of subgroup values}

\item{formula}{a formula, such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}
}
\value{
A number; mean of subgroup means lower control limit.
}
\description{
Calculates the mean of subgroup means lower control limit used when constructing a xBar-R charts.
}
\examples{
set.seed(5555)
df <- data.frame(v=rnorm(60, 0, 1), g=rep(c("A","B","C","D","E"), each=12))
xBar_rBar_LCL(data = df, formula = v~g)
}
