% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-data-frame-dendrogram.R
\name{fortify_data_frame.dendrogram}
\alias{fortify_data_frame.dendrogram}
\alias{fortify_data_frame.hclust}
\title{Build a data frame}
\usage{
\method{fortify_data_frame}{dendrogram}(
  data,
  ...,
  priority = "right",
  center = FALSE,
  type = "rectangle",
  leaf_pos = NULL,
  leaf_braches = NULL,
  reorder_branches = TRUE,
  branch_gap = NULL,
  root = NULL,
  double = TRUE,
  data_arg = NULL,
  call = NULL
)

\method{fortify_data_frame}{hclust}(data, ...)
}
\arguments{
\item{data}{A \code{\link[stats:hclust]{hclust}} or a
\code{\link[stats:dendrogram]{dendrogram}} object.}

\item{...}{Additional arguments passed to \code{dendrogram} method.}

\item{priority}{A string of "left" or "right". if we draw from \code{right} to
\code{left}, the left will override the right, so we take the \code{"left"} as the
priority. If we draw from \code{left} to \code{right}, the right will override the
left, so we take the \code{"right"} as priority. This is used by
\code{\link[=align_dendro]{align_dendro()}} to provide support of facet operation in ggplot2.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to all leaves/tips in the branch. Otherwise (default), plot them in
the middle of the direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{leaf_pos}{The x-coordinates of the leaf node. Must be the same length
of the number of observations in \code{tree}.}

\item{leaf_braches}{Branches of the leaf node. Must be the same length of the
number of observations in \code{tree}. Usually come from \link[stats:cutree]{cutree}.}

\item{reorder_branches}{A single boolean value, indicates whether reorder the
provided \code{leaf_braches} based on the actual index.}

\item{branch_gap}{A single numeric value indicates the gap between different
branches.}

\item{root}{A length one string or numeric indicates the root branch.}

\item{double}{A single logical value indicating whether horizontal lines
should be doubled when segments span multiple branches. If \code{TRUE}, the
horizontal lines will be repeated for each branch that the segment spans. If
\code{FALSE}, only one horizontal line will be drawn. This is used by
\code{\link[=align_dendro]{align_dendro()}} to provide support of facet operation in ggplot2.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}
}
\value{
A \verb{data frame} with the node coordinates:
\itemize{
\item \code{.panel}: Similar with \code{panel} column, but always give the correct
branch for usage of the ggplot facet.
\item \code{.index}: the original index in the tree for the the node
\item \code{label}: node label text
\item \code{x} and \code{y}: x-axis and y-axis coordinates for the node
\item \code{branch}: which branch the node is. You can use this column to color
different groups.
\item \code{panel}: which panel the node is, if we split the plot into panel
using \link[ggplot2:facet_grid]{facet_grid}, this column will show
which panel the node is from. Note: some nodes may
fall outside panel (between two panels), so there are possible
\code{NA} values in this column.
\item \code{leaf}: A logical value indicates whether the node is a leaf.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function converts various objects to a data frame.
}
\section{ggalign attributes}{

\code{edge}: A \verb{data frame} for edge coordinates:
\itemize{
\item \code{.panel}: Similar with \code{panel} column, but always give the correct
branch for usage of the ggplot facet.
\item \code{x} and \code{y}: x-axis and y-axis coordinates for the start node of the edge.
\item \code{xend} and \code{yend}: the x-axis and y-axis coordinates of the terminal node
for edge.
\item \code{branch}: which branch the edge is. You can use this column to color
different groups.
\item \code{panel1} and \code{panel2}: The panel1 and panel2 columns have the same
functionality as \code{panel}, but they are specifically for the \code{edge} data
and correspond to both nodes of each edge.
}
}

\examples{
fortify_data_frame(hclust(dist(USArrests), "ave"))
}
\seealso{
Other \code{\link[=fortify_data_frame]{fortify_data_frame()}} methods:
\code{\link{fortify_data_frame.character}()},
\code{\link{fortify_data_frame.default}()},
\code{\link{fortify_data_frame.matrix}()},
\code{\link{fortify_data_frame.phylo}()}
}
\concept{fortify_data_frame}
