% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spoke_interactive.R
\name{geom_spoke_interactive}
\alias{geom_spoke_interactive}
\title{Create interactive line segments
parameterised by location, direction and distance}
\usage{
geom_spoke_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_spoke]{ggplot2::geom_spoke()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive line segments parameterised by location,
# direction and distance to a ggplot -------
library(ggplot2)
library(ggiraph)

df <- expand.grid(x = 1:10, y = 1:10)
df$angle <- runif(100, 0, 2 * pi)
df$speed <- runif(100, 0, sqrt(0.1 * df$x))

p <- ggplot(df, aes(x, y)) +
  geom_point() +
  geom_spoke_interactive(
    aes(angle = angle, tooltip = round(angle, 2)),
    radius = 0.5
  )
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

p2 <- ggplot(df, aes(x, y)) +
  geom_point() +
  geom_spoke_interactive(aes(
    angle = angle,
    radius = speed,
    tooltip = paste(round(angle, 2), round(speed, 2), sep = "\n")
  ))
x2 <- girafe(ggobj = p2)
if (interactive()) {
  print(x2)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
