% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-methods.R
\name{autoplot.party}
\alias{autoplot.party}
\alias{autoplot.constparty}
\alias{autoplot.modelparty}
\alias{autoplot.lmtree}
\title{autoplot methods for party objects}
\usage{
\method{autoplot}{party}(object, ...)

\method{autoplot}{constparty}(object, ...)

\method{autoplot}{modelparty}(object, plot_var = NULL, ...)

\method{autoplot}{lmtree}(object, plot_var = NULL, show_fit = TRUE,
  ...)
}
\arguments{
\item{object}{object of class party.}

\item{...}{additional parameters}

\item{plot_var}{Which covariate to plot against response. Defaults to second
column in \code{data} of tree.}

\item{show_fit}{If TRUE \code{fitted_values} are drawn.}
}
\description{
autoplot methods for party objects
}
\examples{
library(ggparty)

data("WeatherPlay", package = "partykit")
sp_o <- partysplit(1L, index = 1:3)
sp_h <- partysplit(3L, breaks = 75)
sp_w <- partysplit(4L, index = 1:2)
pn <- partynode(1L, split = sp_o, kids = list(
  partynode(2L, split = sp_h, kids = list(
    partynode(3L, info = "yes"),
    partynode(4L, info = "no"))),
  partynode(5L, info = "yes"),
  partynode(6L, split = sp_w, kids = list(
    partynode(7L, info = "yes"),
    partynode(8L, info = "no")))))
py <- party(pn, WeatherPlay)

autoplot(py)
}
