% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{get_metadata}
\usage{
get_metadata(test = FALSE)
}
\arguments{
\item{test}{logic, Ignored during normal use; included for internal testing
purposes. Defaults to \code{FALSE}.}
}
\value{
sf a spatial polygon grid with attributes:
\code{id}, \code{gridID}, bounding box coordinates, and \code{download_url}.
}
\description{
Returns a spatial grid (as an sf object) containing metadata and download URLs
for global 3D building footprint tiles (3D-GloBFP).
}
\details{
The metadata of 3D Global Building Footprints (3D-GloBFP) dataset is uploaded on zenodo.
More detials about this dataset can to found \href{https://zenodo.org/records/15487037}{here}.

The data is detailed in the following article
}
\examples{
meta <- gloBFPr::get_metadata(test=TRUE)

}
\references{
Che, Y., Li, X., Liu, X., Wang, Y., Liao, W., Zheng, X., Zhang, X., Xu, X.,
Shi, Q., Zhu, J., Zhang, H., Yuan, H., & Dai, Y. (2025).
3D-GloBFP: the first global three-dimensional building footprint dataset.
Zenodo. https://doi.org/10.5281/zenodo.15487037

Che Yangzi, Li Xuecao, Liu Xiaoping, Wang Yuhao, Liao Weilin, Zheng Xianwei,
Zhang Xucai, Xu Xiaocong, Shi Qian, Zhu Jiajun, Zhang Honghui, Yuan Hua, &
Dai Yongjiu (2024). 3D-GloBFP: the first global three-dimensional building
footprint dataset. Earth Syst. Sci. Data, 16, 5357-5374
}
