% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_gmmsslm.R
\name{bootstrap_gmmsslm}
\alias{bootstrap_gmmsslm}
\title{Bootstrap Analysis for gmmsslm}
\usage{
bootstrap_gmmsslm(
  dat,
  zm,
  pi,
  mu,
  sigma,
  paralist,
  xi,
  type,
  iter.max = 500,
  eval.max = 500,
  rel.tol = 1e-15,
  sing.tol = 1e-15,
  B = 2000
)
}
\arguments{
\item{dat}{A matrix where each row represents an individual observation.}

\item{zm}{A matrix or data frame of labels corresponding to dat.}

\item{pi}{A numeric vector representing the mixing proportions.}

\item{mu}{A matrix representing the location parameters.}

\item{sigma}{An array representing the covariance matrix or list of covariance matrices.}

\item{paralist}{A list of parameters.}

\item{xi}{A numeric value representing the coefficient for a logistic function of the Shannon entropy.}

\item{type}{A character value indicating the type of Gaussian mixture model.}

\item{iter.max}{An integer indicating the maximum number of iterations.}

\item{eval.max}{An integer indicating the maximum number of evaluations.}

\item{rel.tol}{A numeric value indicating the relative tolerance.}

\item{sing.tol}{A numeric value indicating the singularity tolerance.}

\item{B}{An integer indicating the number of bootstrap samples.}
}
\value{
A list containing mean and sd of bootstrap samples for pi, mu, sigma, and xi.
}
\description{
This file provides functions to perform bootstrap analysis on the results of the gmmsslm function.

This function performs non-parametric bootstrap to assess the variability of the gmmsslm function outputs.
}
