% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_admin.R
\name{Build}
\alias{Build}
\title{Build Object}
\usage{
Build(
  Build.substitutions = NULL,
  Build.timing = NULL,
  results = NULL,
  logsBucket = NULL,
  steps = NULL,
  buildTriggerId = NULL,
  id = NULL,
  tags = NULL,
  startTime = NULL,
  substitutions = NULL,
  timing = NULL,
  sourceProvenance = NULL,
  createTime = NULL,
  images = NULL,
  projectId = NULL,
  logUrl = NULL,
  finishTime = NULL,
  source = NULL,
  options = NULL,
  timeout = NULL,
  status = NULL,
  statusDetail = NULL,
  artifacts = NULL,
  secrets = NULL,
  availableSecrets = NULL,
  serviceAccount = NULL
)
}
\arguments{
\item{Build.substitutions}{The Build.substitutions object or list of objects}

\item{Build.timing}{The Build.timing object or list of objects}

\item{results}{Output only}

\item{logsBucket}{Google Cloud Storage bucket where logs should be written (see}

\item{steps}{Required}

\item{buildTriggerId}{Output only}

\item{id}{Output only}

\item{tags}{Tags for annotation of a `Build`}

\item{startTime}{Output only}

\item{substitutions}{Substitutions data for `Build` resource}

\item{timing}{Output only}

\item{sourceProvenance}{Output only}

\item{createTime}{Output only}

\item{images}{A list of images to be pushed upon the successful completion of all build}

\item{projectId}{Output only}

\item{logUrl}{Output only}

\item{finishTime}{Output only}

\item{source}{A \link{Source} object specifying the location of the source files to build, usually created by \link{cr_build_source}}

\item{options}{Special options for this build}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{status}{Output only}

\item{statusDetail}{Output only}

\item{artifacts}{Artifacts produced by the build that should be uploaded upon}

\item{secrets}{Secrets to decrypt using Cloud Key Management Service [deprecated]}

\item{availableSecrets}{preferred way to use Secrets, via Secret Manager}

\item{serviceAccount}{service account email to be used for the build}
}
\value{
Build object
}
\description{
Build Object
}
\details{
A build resource in the Cloud Build API.

At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts.
}
\section{Build Macros}{

Fields can include the following variables, which will be expanded when the build is created:-

\itemize{
  \item $PROJECT_ID: the project ID of the build.
  \item $BUILD_ID: the autogenerated ID of the build.
  \item $REPO_NAME: the source repository name specified by RepoSource.
  \item $BRANCH_NAME: the branch name specified by RepoSource.
  \item $TAG_NAME: the tag name specified by RepoSource.
  \item $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or  resolved from the specified branch or tag.
  \item  $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
}
}

\seealso{
Other Cloud Build functions: 
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
