% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{plot_tour}
\alias{plot_tour}
\title{TSP tour simple plotting}
\usage{
plot_tour(z, h, ...)
}
\arguments{
\item{z}{Set of points of a TSP}

\item{h}{List with $tour and $distance components returned from a
TSP tour building algorithm}

\item{...}{Parameters to be passed to \link{plot}}
}
\value{
This function is called by its side effect.
}
\description{
Plotting tours constructed by tour-building routines for TSP
}
\details{
It plots the two-dimensional cities of a TSP and a tour among them
for visualization purposes.  No aesthetically appealing effort
has been invested in this function.
}
\examples{
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)
b <- build_tour_nn_best(d, n)
plot_tour(z,b)

}
\seealso{
\link{build_tour_nn} nearest neighbor heuristic with a single
starting point, \link{build_tour_nn_best} repeats the previous
algorithm with all possible starting points,
\link{compute_distance_matrix} computes the distance matrix of a
set of two-dimensional points.
}
\author{
Cesar Asensio
}
