% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{get_aux_pars.GPModel}
\alias{get_aux_pars.GPModel}
\title{Get (estimated) auxiliary (additional) parameters of the likelihood}
\usage{
\method{get_aux_pars}{GPModel}(gp_model)
}
\arguments{
\item{gp_model}{A \code{GPModel}}
}
\value{
A \code{GPModel}
}
\description{
Get (estimated) auxiliary (additional) parameters of the likelihood such as the shape parameter of a gamma or
a negative binomial distribution. Some likelihoods (e.g., bernoulli_logit or poisson) have no auxiliary parameters
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
X1 <- cbind(rep(1,dim(X)[1]),X) # Add intercept column
y_pos <- exp(y)
gp_model <- fitGPModel(group_data = group_data[,1], y = y_pos, X = X1, likelihood="gamma")
get_aux_pars(gp_model)
}
}
\author{
Fabio Sigrist
}
