% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_weights_parametric_util.R
\name{c_value_function}
\alias{c_value_function}
\alias{solve_c_parametric}
\title{Calculate adjusted hypothesis weights for parametric tests}
\usage{
c_value_function(
  x,
  hypotheses,
  test_corr,
  alpha,
  maxpts = 25000,
  abseps = 1e-06,
  releps = 0
)

solve_c_parametric(
  hypotheses,
  test_corr,
  alpha,
  maxpts = 25000,
  abseps = 1e-06,
  releps = 0
)
}
\arguments{
\item{x}{The root to solve for with \code{stats::uniroot()}.}

\item{hypotheses}{A numeric vector of hypothesis weights. Must be a vector of
values between 0 & 1 (inclusive). The sum of hypothesis weights should not
exceed 1.}

\item{test_corr}{(Optional) A numeric matrix of correlations between test
statistics, which is needed to perform parametric tests using
\code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}}. The number of rows and columns of
this correlation matrix should match the length of \code{p}.}

\item{alpha}{(Optional) A numeric value of the overall significance level,
which should be between 0 & 1. The default is 0.025 for one-sided
hypothesis testing problems; another common choice is 0.05 for two-sided
hypothesis testing problems. Note when parametric tests are used, only
one-sided tests are supported.}

\item{maxpts}{(Optional) An integer scalar for the maximum number of function
values, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 25000.}

\item{abseps}{(Optional) A numeric scalar for the absolute error tolerance,
which is needed to perform parametric tests using the \code{mvtnorm::GenzBretz}
algorithm. The default is 1e-6.}

\item{releps}{(Optional) A numeric scalar for the relative error tolerance
as double, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 0.}
}
\value{
\itemize{
\item \code{c_value_function()} returns the difference between
\eqn{\alpha} and the Type I error of the parametric test with the \eqn{c}
value of \code{x}, adjusted for the correlation between test statistics using
parametric tests based on equation (6) of Xi et al. (2017).
\item \code{solve_c_parametric()} returns the c value adjusted for the
correlation between test statistics using parametric tests based on
equation (6) of Xi et al. (2017).
}
}
\description{
An intersection hypothesis can be rejected if its p-values are less than or
equal to their adjusted significance levels, which are their adjusted
hypothesis weights times \eqn{\alpha}. For Bonferroni tests, their adjusted
hypothesis weights are their hypothesis weights of the intersection
hypothesis. Additional adjustment is needed for parametric tests:
\itemize{
\item Parametric tests for \code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}},
\itemize{
\item Note that one-sided tests are required for parametric tests.
}
}
}
\references{
Xi, D., Glimm, E., Maurer, W., and Bretz, F. (2017). A unified framework
for weighted parametric multiple test procedures.
\emph{Biometrical Journal}, 59(5), 918-931.
}
\seealso{
\code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}} for adjusted hypothesis weights using
parametric tests.
}
\keyword{internal}
