% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{location-helper}
\alias{location-helper}
\title{Helper to target cells at \code{locations}}
\description{
This listing with locations corresponding roughly from top to
bottom of a table:
\itemize{
\item \code{\link[=cells_title]{cells_title()}}: targets the table title or the table subtitle depending on
the value given to the \code{groups} argument (\code{"title"} or \code{"subtitle"}).
\item \code{\link[=cells_stubhead]{cells_stubhead()}}: targets the stubhead location, a cell of which is only
available when there is a stub; a label in that location can be created by
using \code{\link[=tab_stubhead]{tab_stubhead()}}.
\item \code{\link[=cells_column_spanners]{cells_column_spanners()}}*: targets the spanner column labels with the
\code{spanners} argument; spanner column labels appear above the column labels.
\item \code{\link[=cells_column_labels]{cells_column_labels()}}*: targets the column labels with its \code{columns}
argument.
\item \code{\link[=cells_row_groups]{cells_row_groups()}}*: targets the row group labels in any available row
groups using the \code{groups} argument.
\item \code{\link[=cells_stub]{cells_stub()}}*: targets row labels in the table stub using the \code{rows}
argument.
\item \code{\link[=cells_body]{cells_body()}}*: targets data cells in the table body using intersections of
\code{columns} and \code{rows}.
\item \code{\link[=cells_summary]{cells_summary()}}: targets summary cells in the table body using the
\code{groups} argument and intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_grand_summary]{cells_grand_summary()}}: targets cells of the table's grand summary using
intersections of \code{columns} and \code{rows}
\item \code{\link[=cells_stub_summary]{cells_stub_summary()}}: targets summary row labels in the table stub using
the \code{groups} and \code{rows} arguments.
\item \code{\link[=cells_stub_grand_summary]{cells_stub_grand_summary()}}: targets grand summary row labels in the table
stub using the \code{rows} argument.
\item \code{\link[=cells_footnotes]{cells_footnotes()}}: targets all footnotes in the table footer (cannot be
used with \code{\link[=tab_footnote]{tab_footnote()}}).
\item \code{\link[=cells_source_notes]{cells_source_notes()}}: targets all source notes in the table footer
(cannot be used with \code{\link[=tab_footnote]{tab_footnote()}}).
}

\code{*} are the only functions usable by the \verb{text_*()} functions.
}
\section{Note}{
When using any of the location helper functions with an appropriate function
that has a \code{locations} argument (e.g., \code{\link[=tab_style]{tab_style()}}), multiple locations
can be targeted by enclosing several \verb{cells_*()} helper functions in a
\code{list()} (e.g., \code{list(cells_body(), cells_grand_summary())}).
}

\seealso{
Functions with \code{locations} argument:
\itemize{
\item \code{\link[=tab_footnote]{tab_footnote()}}
\item \code{\link[=tab_style]{tab_style()}}
\item \code{\link[=text_transform]{text_transform()}}
\item \code{\link[=text_replace]{text_replace()}}
\item \code{\link[=text_case_when]{text_case_when()}}
\item \code{\link[=text_case_match]{text_case_match()}}
}

These functions contain more example of usage.

Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()}
}
\concept{location helper functions}
\keyword{internal}
