% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_source_note.R
\name{modify_source_note}
\alias{modify_source_note}
\alias{remove_source_note}
\title{Modify source note}
\usage{
modify_source_note(x, source_note, text_interpret = c("md", "html"))

remove_source_note(x, source_note_id = NULL)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object.}

\item{source_note}{(\code{string})\cr
A string to add as a source note.}

\item{text_interpret}{(\code{string})\cr
String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.
Applies to tables printed with \code{{gt}}.}

\item{source_note_id}{(\code{integers})\cr
Integers specifying the ID of the source note to remove.
Source notes are indexed sequentially at the time of creation.
Default is \code{NULL}, which removes all source notes.}
}
\value{
gtsummary object
}
\description{
Add and remove source notes from a table.
Source notes are similar to footnotes, expect they are not linked to a cell in
the table.
}
\details{
Source notes are not supported by \code{as_kable_extra()}.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
tbl <- tbl_summary(trial, include = c(marker, grade), missing = "no") |>
  modify_source_note("Results as of June 26, 2015")

# Example 2 ----------------------------------
remove_source_note(tbl, source_note_id = 1)
\dontshow{\}) # examplesIf}
}
