% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion.R
\name{proportion}
\alias{proportion}
\alias{proportion.data.frame}
\alias{proportion.survey.design}
\alias{proportion.default}
\title{Compute proportions}
\usage{
proportion(data, ...)

\method{proportion}{data.frame}(
  data,
  ...,
  .by = NULL,
  .na.rm = FALSE,
  .weight = NULL,
  .scale = 100,
  .sort = FALSE,
  .drop = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = list(correct = TRUE)
)

\method{proportion}{survey.design}(
  data,
  ...,
  .by = NULL,
  .na.rm = FALSE,
  .scale = 100,
  .sort = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = NULL
)

\method{proportion}{default}(
  data,
  ...,
  .na.rm = FALSE,
  .scale = 100,
  .sort = FALSE,
  .drop = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = list(correct = TRUE)
)
}
\arguments{
\item{data}{A vector, a data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variable(s) for those
computing proportions.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optional additional
variables to group by (in addition to those eventually previously declared
using \code{\link[dplyr:group_by]{dplyr::group_by()}}).}

\item{.na.rm}{Should \code{NA} values be removed
(from variables declared in \code{...})?}

\item{.weight}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency
weights. Can be \code{NULL} or a variable.}

\item{.scale}{A scaling factor applied to proportion. Use \code{1} for keeping
proportions unchanged.}

\item{.sort}{If \code{TRUE}, will show the highest proportions at the top.}

\item{.drop}{If \code{TRUE}, will remove empty groups from the output.}

\item{.conf.int}{If \code{TRUE}, will estimate confidence intervals.}

\item{.conf.level}{Confidence level for the returned confidence intervals.}

\item{.options}{Additional arguments passed to \code{\link[stats:prop.test]{stats::prop.test()}}
or \code{\link[srvyr:survey_mean]{srvyr::survey_prop()}}.}
}
\value{
A tibble.

A tibble with one row per group.
}
\description{
\code{proportion()} lets you quickly count observations (like \code{\link[dplyr:count]{dplyr::count()}})
and compute relative proportions. Proportions are computed separately by
group (see examples).
}
\examples{
# using a vector
titanic$Class |> proportion()

# univariable table
titanic |> proportion(Class)
titanic |> proportion(Class, .sort = TRUE)
titanic |> proportion(Class, .conf.int = TRUE)
titanic |> proportion(Class, .conf.int = TRUE, .scale = 1)

# bivariable table
titanic |> proportion(Class, Survived) # proportions of the total
titanic |> proportion(Survived, .by = Class) # row proportions
titanic |> # equivalent syntax
  dplyr::group_by(Class) |>
  proportion(Survived)

# combining 3 variables or more
titanic |> proportion(Class, Sex, Survived)
titanic |> proportion(Sex, Survived, .by = Class)
titanic |> proportion(Survived, .by = c(Class, Sex))

# missing values
dna <- titanic
dna$Survived[c(1:20, 500:530)] <- NA
dna |> proportion(Survived)
dna |> proportion(Survived, .na.rm = TRUE)

\donttest{
## SURVEY DATA ------------------------------------------------------

ds <- srvyr::as_survey(titanic)

# univariable table
ds |> proportion(Class)
ds |> proportion(Class, .sort = TRUE)
ds |> proportion(Class, .conf.int = TRUE)
ds |> proportion(Class, .conf.int = TRUE, .scale = 1)

# bivariable table
ds |> proportion(Class, Survived) # proportions of the total
ds |> proportion(Survived, .by = Class) # row proportions
ds |> dplyr::group_by(Class) |> proportion(Survived)

# combining 3 variables or more
ds |> proportion(Class, Sex, Survived)
ds |> proportion(Sex, Survived, .by = Class)
ds |> proportion(Survived, .by = c(Class, Sex))

# missing values
dsna <- srvyr::as_survey(dna)
dsna |> proportion(Survived)
dsna |> proportion(Survived, .na.rm = TRUE)
}
}
\keyword{univar}
