% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-utils.R
\name{is_rs_id}
\alias{is_rs_id}
\title{Is a string a valid rsID?}
\usage{
is_rs_id(str, convert_NA_to_FALSE = TRUE)
}
\arguments{
\item{str}{A character vector of putative SNP reference IDs of the form
rs[0-9]+.}

\item{convert_NA_to_FALSE}{Whether to preserve \code{NA}
(\code{convert_NA_to_FALSE = TRUE}) or whether to return \code{FALSE} when
an \code{NA} is found (\code{convert_NA_to_FALSE = FALSE}).}
}
\value{
Returns a logical vector of the same length as \code{str},
  \code{TRUE} for strings that are valid rs IDs, and \code{FALSE} otherwise.
}
\description{
Find which strings are valid SNP reference IDs, i.e., of the form rs[0-9]+.
Please note that this only does a syntax validation on the strings. It does
not check whether the actual IDs exist in dbSNP.
}
\keyword{internal}
